/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.constraint;

import com.teamscale.index.code_clones.constraint.UnitListDelta;
import com.teamscale.index.code_clones.core.StatementUnit;
import com.teamscale.index.code_clones.core.TokenUnit;
import com.teamscale.index.code_clones.core.Unit;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

class UnitListDiffer {
    UnitListDiffer() {
    }

    public static UnitListDelta computeDelta(Collection<List<Unit>> unitLists) {
        CCSMAssert.isTrue((unitLists.size() >= 2 ? 1 : 0) != 0, (String)"Need at least 2 lists to compute Delta");
        ArrayList<Pair> textLists = new ArrayList<Pair>();
        for (List<Unit> unitList : unitLists) {
            List<String> unnormalizedTokenContent = UnitListDiffer.getUnnormalizedUnitContent(unitList, tokenUnit -> !TokenUnit.couldBeNormalized(tokenUnit.getType()));
            textLists.add(new Pair(unitList, unnormalizedTokenContent));
        }
        UnitListDelta maxDelta = null;
        for (ImmutablePair pair : CollectionUtils.computeUnorderedPairs(textLists)) {
            UnitListDelta delta = UnitListDiffer.computeDelta((Pair<List<Unit>, List<String>>)((Pair)pair.getFirst()), (Pair<List<Unit>, List<String>>)((Pair)pair.getSecond()));
            if (maxDelta != null && !UnitListDiffer.isBiggerDelta(maxDelta, delta)) continue;
            maxDelta = delta;
        }
        return maxDelta;
    }

    private static List<String> getUnnormalizedUnitContent(List<Unit> units, Predicate<TokenUnit> tokenUnitFilter) {
        ArrayList<String> statementTexts = new ArrayList<String>();
        for (Unit unit : units) {
            if (unit instanceof StatementUnit) {
                StatementUnit statement = (StatementUnit)unit;
                UnitListDiffer.extractUnnormalizedContent(statement, statementTexts, tokenUnitFilter);
                continue;
            }
            statementTexts.add(unit.getUnnormalizedContent());
        }
        return statementTexts;
    }

    private static void extractUnnormalizedContent(StatementUnit statement, List<String> statementTexts, Predicate<TokenUnit> tokenUnitFilter) {
        for (TokenUnit tokenUnit : statement.getTokens()) {
            if (StringUtils.isEmpty((String)tokenUnit.getContent()) || tokenUnitFilter.test(tokenUnit)) continue;
            String unnormalizedContent = tokenUnit.getUnnormalizedContent();
            unnormalizedContent = unnormalizedContent.toLowerCase();
            statementTexts.add(unnormalizedContent);
        }
    }

    private static boolean isBiggerDelta(UnitListDelta maxDelta, UnitListDelta delta) {
        return delta.getSimilarity() < maxDelta.getSimilarity() || delta.getSimilarity() == maxDelta.getSimilarity() && delta.getEquality() < maxDelta.getEquality() || delta.getSimilarity() == maxDelta.getSimilarity() && delta.getEquality() == maxDelta.getEquality() && delta.getTermEquality() < maxDelta.getTermEquality();
    }

    private static UnitListDelta computeDelta(Pair<List<Unit>, List<String>> units1, Pair<List<Unit>, List<String>> units2) throws AssertionError {
        List texts1 = (List)units1.getSecond();
        List texts2 = (List)units2.getSecond();
        UnitListDiffer.makeListsEqualLength(texts1, texts2);
        CounterSet mappings = new CounterSet();
        for (int i = 0; i < texts1.size(); ++i) {
            String unit1 = (String)texts1.get(i);
            String unit2 = (String)texts2.get(i);
            mappings.inc((Object)new ImmutablePair((Object)unit1, (Object)unit2));
        }
        UnitListDelta delta = new UnitListDelta();
        Set<String> terms1 = UnitListDiffer.getTerms((List)units1.getFirst());
        Set<String> terms2 = UnitListDiffer.getTerms((List)units2.getFirst());
        delta.calculateAndSetTermEquality(terms1, terms2);
        for (ImmutablePair mapping : mappings.getKeys()) {
            int count = mappings.getValue((Object)mapping);
            if (((String)mapping.getFirst()).equals(mapping.getSecond())) {
                delta.incEquals(count);
                continue;
            }
            if (count > 1) {
                delta.incRenames(count);
                continue;
            }
            delta.incDifferences(1);
        }
        CCSMAssert.isTrue((((List)units1.getSecond()).size() == delta.getSize() ? 1 : 0) != 0, (String)"Delta is inconsistent");
        return delta;
    }

    private static Set<String> getTerms(List<Unit> units) {
        return new HashSet<String>(UnitListDiffer.getUnnormalizedUnitContent(units, tokenUnit -> tokenUnit.getType().getTokenClass() != ETokenType.ETokenClass.IDENTIFIER));
    }

    private static void makeListsEqualLength(List<String> list1, List<String> list2) {
        String dummyTokenText = "##DUMMY!$\u00a7TOKEN##";
        while (list1.size() < list2.size()) {
            list1.add(dummyTokenText);
        }
        while (list2.size() < list1.size()) {
            list2.add(dummyTokenText);
        }
    }
}

