/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import com.teamscale.index.code_clones.detection.CloneChunk;

public class SuffixTreeChunkWrapper {
    private final CloneChunk chunk;

    public SuffixTreeChunkWrapper(CloneChunk originalChunk) {
        this.chunk = originalChunk;
    }

    public boolean equals(Object other) {
        if (other instanceof SuffixTreeChunkWrapper) {
            SuffixTreeChunkWrapper otherChunk = (SuffixTreeChunkWrapper)other;
            if (this.isSentinel() || otherChunk.isSentinel()) {
                return this == other;
            }
            return otherChunk.chunk.getChunkHash() == this.chunk.getChunkHash();
        }
        return false;
    }

    public int hashCode() {
        if (this.isSentinel()) {
            return System.identityHashCode(this);
        }
        return Long.hashCode(this.chunk.getChunkHash());
    }

    public CloneChunk getChunk() {
        return this.chunk;
    }

    public boolean isSentinel() {
        return this.chunk == null;
    }

    public static SuffixTreeChunkWrapper createSentinel() {
        return new SuffixTreeChunkWrapper(null);
    }
}

