/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class AstPositionCalculator {
    public static EAstPosition getAstPosition(IToken commentToken, List<ShallowEntity> topLevelEntities) {
        if (!AstPositionCalculator.hasNonEmptyNonMetaEntities(topLevelEntities)) {
            return EAstPosition.HEADER;
        }
        return AstPositionCalculator.traverseEntities(topLevelEntities, commentToken);
    }

    private static boolean hasNonEmptyNonMetaEntities(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            if (entity.getType() == EShallowEntityType.META || entity.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static EAstPosition traverseEntities(List<ShallowEntity> entities, IToken commentToken) {
        ShallowEntity previous = null;
        for (ShallowEntity entity : entities) {
            if (entity.getType() == EShallowEntityType.META || entity.isEmpty()) continue;
            if (commentToken.getEndOffset() < entity.getStartOffset()) {
                return AstPositionCalculator.determineLocationForReferenceEntity(entity);
            }
            if (commentToken.getEndOffset() < entity.getEndOffset()) {
                if (AstPositionCalculator.hasNonEmptyNonMetaEntities((List<ShallowEntity>)entity.getChildren())) {
                    return AstPositionCalculator.traverseEntities((List<ShallowEntity>)entity.getChildren(), commentToken);
                }
                return EAstPosition.INLINE;
            }
            previous = entity;
        }
        CCSMAssert.isTrue((previous != null ? 1 : 0) != 0, (String)"May not call with empty entities list or entities list containing only meta entities.");
        return AstPositionCalculator.determineLocationForReferenceEntity(previous);
    }

    private static EAstPosition determineLocationForReferenceEntity(ShallowEntity referenceEntity) {
        switch (referenceEntity.getType()) {
            case METHOD: {
                if (AstPositionCalculator.isPropertyGetterSetter(referenceEntity) || AstPositionCalculator.isLambdaFunction(referenceEntity)) {
                    return EAstPosition.INLINE;
                }
            }
            case ATTRIBUTE: {
                return EAstPosition.INTERFACE;
            }
            case STATEMENT: {
                return EAstPosition.INLINE;
            }
            case MODULE: 
            case TYPE: {
                return EAstPosition.HEADER;
            }
            case META: {
                throw new AssertionError((Object)"May not call with META entity as reference!");
            }
        }
        throw new AssertionError((Object)("Unknown entity type: " + String.valueOf(referenceEntity.getType())));
    }

    private static boolean isPropertyGetterSetter(ShallowEntity entity) {
        return entity.getParent() != null && entity.getParent().getType() == EShallowEntityType.ATTRIBUTE;
    }

    private static boolean isLambdaFunction(ShallowEntity method) {
        return method.getSubtype().equals("lambda");
    }

    public static enum EAstPosition {
        HEADER,
        INTERFACE,
        INLINE;

    }
}

