/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentClassificationCache;
import com.teamscale.index.comment_analysis.CommentExtractor;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;

public abstract class CommentAnalysisBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PACKAGE_VISIBILITY_COMMENT_PATTERN = Pattern.compile("/\\*\\s?package\\s?\\*/");

    public void performAnalysis(Collection<TokenElementInfo> elements, CommentClassificationCache classificationCache) {
        for (TokenElementInfo element : elements) {
            this.analyzeTokens((List<IToken>)element.getTokens(), element, classificationCache);
        }
    }

    private void analyzeTokens(List<IToken> tokens, TokenElementInfo element, CommentClassificationCache classificationCache) {
        this.setUpElementAnalysis();
        try {
            List<Comment> comments = this.extractComments(tokens, element);
            this.analyzeComments(comments, element, tokens, classificationCache);
            this.completeElementAnalysis(tokens, element);
        }
        catch (ConQATException e) {
            LOGGER.error("Error in extracting comments from element " + element.getUniformPath(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Critical error in extracting comments from element " + element.getUniformPath(), (Throwable)e);
        }
    }

    private List<Comment> extractComments(List<IToken> tokens, TokenElementInfo element) {
        if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage())) {
            return new ArrayList<Comment>();
        }
        List<IToken> unifiedCommentTokens = CommentAnalysisBase.unifyMultipleSingleLineComments(tokens);
        if (element.getLanguage() == ELanguage.JAVA) {
            unifiedCommentTokens = CommentAnalysisBase.removePackageVisibilityComments(unifiedCommentTokens);
        }
        return CommentExtractor.extractComments(unifiedCommentTokens, element, this.isRemoveCommentTags());
    }

    protected boolean isRemoveCommentTags() {
        return false;
    }

    protected abstract void analyzeComments(List<Comment> var1, TokenElementInfo var2, List<IToken> var3, CommentClassificationCache var4) throws ConQATException;

    protected void setUpElementAnalysis() {
    }

    protected void completeElementAnalysis(List<IToken> tokens, TokenElementInfo element) {
    }

    public static List<IToken> unifyMultipleSingleLineComments(List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        ArrayList<IToken> consecutiveLineComments = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (CommentAnalysisBase.isSingleLineCommentToken(token)) {
                if (consecutiveLineComments.isEmpty() || ((IToken)consecutiveLineComments.get(consecutiveLineComments.size() - 1)).getLineNumber() + 1 == token.getLineNumber()) {
                    consecutiveLineComments.add(token);
                    continue;
                }
                result.add(CommentAnalysisBase.mergeTokensOfCommentBlock(consecutiveLineComments));
                consecutiveLineComments.clear();
                consecutiveLineComments.add(token);
                continue;
            }
            if (!consecutiveLineComments.isEmpty()) {
                result.add(CommentAnalysisBase.mergeTokensOfCommentBlock(consecutiveLineComments));
                consecutiveLineComments.clear();
            }
            result.add(token);
        }
        if (!consecutiveLineComments.isEmpty()) {
            result.add(CommentAnalysisBase.mergeTokensOfCommentBlock(consecutiveLineComments));
        }
        return result;
    }

    private static IToken mergeTokensOfCommentBlock(List<IToken> comments) {
        IToken firstToken = comments.get(0);
        StringBuilder commentBuilder = new StringBuilder();
        for (int i = 0; i < comments.size() - 1; ++i) {
            for (int missingSpaces = comments.get(i + 1).getOffset() - comments.get(i).getEndOffset() - 2; missingSpaces > 0; --missingSpaces) {
                commentBuilder.append(' ');
            }
            commentBuilder.append(comments.get(i).getText());
            commentBuilder.append('\n');
        }
        commentBuilder.append(comments.get(comments.size() - 1).getText());
        return firstToken.newToken(firstToken.getType(), firstToken.getOffset(), firstToken.getLineNumber(), commentBuilder.toString(), firstToken.getOriginId());
    }

    private static boolean isSingleLineCommentToken(IToken token) {
        ETokenType tokenType = token.getType();
        if (tokenType == ETokenType.END_OF_LINE_COMMENT) {
            return true;
        }
        if (tokenType == ETokenType.TRADITIONAL_COMMENT && token.getText().length() >= 3) {
            String firstThreeCharacters = token.getText().substring(0, 3);
            return firstThreeCharacters.startsWith("/*") && firstThreeCharacters.charAt(2) != '*';
        }
        if (token.getLanguage() == ELanguage.CS) {
            return tokenType == ETokenType.DOCUMENTATION_COMMENT;
        }
        if (token.getLanguage().isCppOrC()) {
            return token.getText().startsWith("//");
        }
        return false;
    }

    private static List<IToken> removePackageVisibilityComments(List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.TRADITIONAL_COMMENT && PACKAGE_VISIBILITY_COMMENT_PATTERN.matcher(token.getText()).matches()) continue;
            result.add(token);
        }
        return result;
    }
}

