/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class CommentCompletenessAssessor
extends CommentCompletenessAnalyzerBase {
    public static final String DEFAULT_PARTITION = "comment-completeness";
    public static final String METHODS_PARTITION = "comment-completeness-methods";
    public static final String ATTRIBUTES_PARTITION = "comment-completeness-attributes";
    public static final String TYPES_PARTITION = "comment-completeness-types";
    private final boolean assessmentEnabled;
    private final boolean assessmentForTypesEnabled;
    private final boolean assessmentForMethodsEnabled;
    private final boolean assessmentForAttributesEnabled;
    private final Map<String, Map<String, Assessment>> assessments = new HashMap<String, Map<String, Assessment>>();

    public CommentCompletenessAssessor(boolean requireDocComment, String entitySelectionExpression, boolean allowCommentInside, boolean assessmentEnabled, boolean assessmentForTypesEnabled, boolean assessmentForMethodsEnabled, boolean assessmentForAttributesEnabled) {
        super(requireDocComment, entitySelectionExpression, allowCommentInside);
        this.assessmentEnabled = assessmentEnabled;
        this.assessmentForTypesEnabled = assessmentForTypesEnabled;
        this.assessmentForMethodsEnabled = assessmentForMethodsEnabled;
        this.assessmentForAttributesEnabled = assessmentForAttributesEnabled;
        CommentCompletenessAssessor.getPartitions().forEach(p -> this.assessments.put((String)p, new HashMap()));
    }

    @Override
    protected void analyzeSelectedEntity(ShallowEntity entity, TokenElementInfo element, CommentCompletenessAnalyzerBase.ECommentInspectionResult commentType) {
        if (commentType == CommentCompletenessAnalyzerBase.ECommentInspectionResult.COMMENTED) {
            this.addAssessmentsFor(entity, element, ETrafficLightColor.GREEN);
        } else {
            this.addAssessmentsFor(entity, element, ETrafficLightColor.RED);
        }
    }

    @Override
    protected void analyzeTokens(List<IToken> tokens, TokenElementInfo element) throws StorageException {
        CommentCompletenessAssessor.getPartitions().forEach(p -> this.addEmptyAssessmentIfAbsent(element, (String)p));
        super.analyzeTokens(tokens, element);
    }

    private void addEmptyAssessmentIfAbsent(TokenElementInfo element, String partition) {
        this.assessments.get(partition).putIfAbsent(element.getUniformPath(), new Assessment());
    }

    private void addAssessmentIfEnabled(TokenElementInfo element, String partition, ETrafficLightColor color, boolean enabled) {
        if (!enabled) {
            return;
        }
        this.addEmptyAssessmentIfAbsent(element, partition);
        this.assessments.get(partition).get(element.getUniformPath()).add(color);
    }

    private void addAssessmentsFor(ShallowEntity entity, TokenElementInfo element, ETrafficLightColor color) {
        switch (entity.getType()) {
            case METHOD: {
                this.addAssessmentIfEnabled(element, METHODS_PARTITION, color, this.assessmentForMethodsEnabled);
                break;
            }
            case ATTRIBUTE: {
                this.addAssessmentIfEnabled(element, ATTRIBUTES_PARTITION, color, this.assessmentForAttributesEnabled);
                break;
            }
            case TYPE: {
                this.addAssessmentIfEnabled(element, TYPES_PARTITION, color, this.assessmentForTypesEnabled);
                break;
            }
        }
        this.addAssessmentIfEnabled(element, DEFAULT_PARTITION, color, this.assessmentEnabled);
    }

    public Map<String, Map<String, Assessment>> getAssessments() {
        return this.assessments;
    }

    public static List<String> getPartitions() {
        return List.of(DEFAULT_PARTITION, METHODS_PARTITION, ATTRIBUTES_PARTITION, TYPES_PARTITION);
    }
}

