/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.classification.MethodFinder;
import com.teamscale.index.comment_analysis.identifier.CompoundBreaker;
import com.teamscale.index.comment_analysis.identifier.EStemmer;
import com.teamscale.index.comment_analysis.utils.CommentUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CoherenceUtils {
    private static final Pattern WORD_MATCHING_PATTERN = Pattern.compile("[\\p{L}\\p{N}]{2,}");

    private static boolean hasSimilarWord(String methodName, String comment, ELanguage language) {
        List words = StringUtils.lowercaseList(CoherenceUtils.getCommentWords(comment, language));
        for (String part : CoherenceUtils.getIdentifierNameParts(methodName)) {
            for (String word : words) {
                if (!CoherenceUtils.isSimilar(word, part)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNumCorrespondingWords(String identifier, String comment, ELanguage language) {
        List<String> words = CoherenceUtils.stemAll(CoherenceUtils.getCommentWords(comment, language));
        List<String> identifierParts = CoherenceUtils.stemAll(CoherenceUtils.getIdentifierNameParts(identifier));
        int count = 0;
        boolean identifierHasOnePart = identifierParts.size() == 1;
        block0: for (String word : words) {
            for (String part : identifierParts) {
                if (!CoherenceUtils.isSimilar(word, part) && (!identifierHasOnePart || word.length() <= 2 || !part.contains(word))) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    private static boolean isSimilar(String word1, String word2) {
        return word1.equals(word2) || StringUtils.isEditDistanceAtMost1((String)word1, (String)word2) && (word1.length() > 2 || word2.length() > 2);
    }

    private static List<String> stemAll(List<String> words) {
        ArrayList<String> result = new ArrayList<String>(words.size());
        for (String word : words) {
            result.add(EStemmer.ENGLISH.stem(word.toLowerCase()));
        }
        return result;
    }

    private static List<String> getIdentifierNameParts(String identifier) {
        List<String> identifierParts = CompoundBreaker.breakCompound(identifier);
        ArrayList<String> result = new ArrayList<String>();
        for (int start = 0; start < identifierParts.size(); ++start) {
            for (int end = start + 1; end <= identifierParts.size(); ++end) {
                List<String> subParts = identifierParts.subList(start, end);
                String identifierPart = StringUtils.concat(subParts, (String)"");
                result.add(identifierPart.toLowerCase());
            }
        }
        return result;
    }

    public static List<String> getCommentWords(String comment, ELanguage language) {
        comment = CommentUtils.getTextInComment(comment, language);
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = WORD_MATCHING_PATTERN.matcher(comment);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static boolean hasContextCorrelation(Comment comment) {
        String commentText = comment.getText();
        if (CommentUtils.isDefaultComment(commentText) || CommentUtils.hasOnlyJavaDoc(commentText)) {
            return true;
        }
        MethodFinder methodFinder = comment.getMethodFinder();
        int tokenIndex = comment.getTokenIndex();
        String methodName = methodFinder.getNextDefinition(tokenIndex);
        return CoherenceUtils.hasSimilarWord(methodName, commentText, comment.getLanguage());
    }

    private CoherenceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

