/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.utils;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class Member {
    private final String memberName;
    private final int startTokenOffset;
    private final int endTokenOffset;

    public Member(ShallowEntity entity) {
        UnmodifiableList includedTokens = entity.includedTokens();
        CCSMAssert.isFalse((boolean)includedTokens.isEmpty(), (String)"May not create member without tokens!");
        this.memberName = Member.determineName(entity);
        this.startTokenOffset = ((IToken)includedTokens.get(0)).getOffset();
        this.endTokenOffset = ((IToken)CollectionUtils.getLast((List)includedTokens)).getOffset();
        CCSMAssert.isTrue((entity.getType() == EShallowEntityType.METHOD || entity.getType() == EShallowEntityType.ATTRIBUTE ? 1 : 0) != 0, (String)("Expected either method or attribute, was: " + String.valueOf(entity.getType())));
    }

    private static String determineName(ShallowEntity entity) {
        if (!StringUtils.isEmpty((String)entity.getName())) {
            return entity.getName();
        }
        return entity.getSubtype();
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean containsOffset(int offset) {
        return offset >= this.startTokenOffset && offset <= this.endTokenOffset;
    }
}

