/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.utils;

import com.teamscale.index.comment_analysis.utils.Member;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;

public class MemberExtractor {
    private final List<ShallowEntity> entities;
    private final ListMap<String, Member> members = new ListMap();

    public MemberExtractor(List<ShallowEntity> entities) {
        this.entities = entities;
        this.extractMembers();
    }

    private void extractMembers() {
        ShallowEntity.traverse(this.entities, (IShallowEntityVisitor)new MemberVisitor());
    }

    public boolean containsMemberIdentifier(String memberName, int positionName) {
        for (Member member : (List)this.members.getCollectionOrEmpty((Object)memberName)) {
            if (!member.containsOffset(positionName)) continue;
            return true;
        }
        return false;
    }

    private final class MemberVisitor
    implements IShallowEntityVisitor {
        private MemberVisitor() {
        }

        public boolean visit(ShallowEntity entity) {
            if (!(entity.getType() != EShallowEntityType.ATTRIBUTE && entity.getType() != EShallowEntityType.METHOD || entity.includedTokens().isEmpty())) {
                Member member = new Member(entity);
                MemberExtractor.this.members.add((Object)member.getMemberName(), (Object)member);
            }
            return true;
        }

        public void endVisit(ShallowEntity entity) {
        }
    }
}

