/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.commit_alert.clone.InconsistentCloneChangeAlerter;
import com.teamscale.index.configuration.CloningConfiguration;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class InconsistentCloneChangeAlertConfiguration
extends AnalysisConfigurationBase {
    @ConfigExposed(name="Alert inconsistent changes", description="Whether to add alerts for inconsistent clone changes.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private boolean alertInconsistentChanges = true;

    public InconsistentCloneChangeAlertConfiguration() {
        this.autoExpose();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!IndexBasedAnalysisConstants.containsCodeLanguage(languages) || IndexBasedAnalysisConstants.allLanguagesHaveStructuringAndCloningDisabled(languages)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        AnalysisGroupDescriptor cloningAnalysisGroup = template.getAnalysisGroup("Code Clones");
        if (cloningAnalysisGroup != null) {
            cloningAnalysisGroup.insert((ConfigurationItemBase)this.getOptionForField("alertInconsistentChanges"), 0);
        } else {
            CCSMAssert.fail((String)"Analysis group Code Clones not found");
        }
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (this.alertInconsistentChanges) {
            InconsistentCloneChangeAlertConfiguration.createCloneAlertTrigger(proxy);
        }
    }

    private static void createCloneAlertTrigger(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(InconsistentCloneChangeAlerter.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return Collections.singletonList(CloningConfiguration.class);
    }
}

