/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.precommit.DeleteStalePreCommitBranchesTrigger;
import com.teamscale.index.precommit.PreCommitUploadChangeRetriever;
import com.teamscale.index.precommit.PreCommitUploadPersister;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;

public class PreCommitAnalysisConfiguration
extends AnalysisConfigurationBase {
    public static final String PRECOMMIT_COMMIT_TREE_INDEX = "precommit-commit-tree";

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        PreCommitAnalysisConfiguration.createIndexes(proxy);
        PreCommitAnalysisConfiguration.createTriggers(proxy);
    }

    private static void createIndexes(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(CommitTreeIndex.class, PRECOMMIT_COMMIT_TREE_INDEX);
        proxy.createProjectIndex(PreCommitUploadStagingIndex.class);
    }

    private static void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(PreCommitUploadChangeRetriever.class));
        proxy.createTrigger(new TriggerBuilder(PreCommitUploadPersister.class, ETriggerConcurrency.PARALLEL));
        TriggerBuilder deletionTrigger = new TriggerBuilder(DeleteStalePreCommitBranchesTrigger.class, ETriggerConcurrency.ISOLATED);
        deletionTrigger.setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)DeleteStalePreCommitBranchesTrigger.SCHEDULING_INTERVAL);
        deletionTrigger.setSchedulingParameter(ESchedulingParameter.CANCELABLE, (Object)false);
        proxy.createTrigger(deletionTrigger);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        this.autoExpose(template.getCodeScope());
    }

    public boolean isCoreConfiguration() {
        return true;
    }
}

