/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.simulink.clones.InvertedSimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneChangeIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneChangeIndexSynchronizer;
import com.teamscale.index.simulink.clones.SimulinkCloneDetector;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentInverter;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentSynchronizer;
import com.teamscale.index.simulink.clones.SimulinkCoverableBlockCountIndex;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class SimulinkCloneConfiguration
extends AnalysisConfigurationBase {
    public static final String NON_TRIVIAL_BLOCKS_METRIC_NAME = "non-trivial-blocks";
    public static final String CLONED_BLOCKS_METRIC_NAME = "cloned-blocks";
    private static final int DEFAULT_CLONE_MIN_SIZE = 10;
    private static final String DESCRIPTION_PATH = "cqse-clone.md";
    private final FindingDescriptor cloneFindingDescriptor = new FindingDescriptor("Simulink Clones", EAnalysisTool.TEAMSCALE, EnumSet.of(ELanguage.SIMULINK), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-clone.md").orElseThrow());
    @ConfigExposed(name="Minimal clone size", description="The minimal size of detected clones in non-trivial blocks.")
    private int cloneMinSize = 10;
    private final MetricDescriptor cloneCoverageMetric = new MetricDescriptor("Block Clone Coverage", "The relative amount of blocks covered by at least one clone.");

    public SimulinkCloneConfiguration() {
        this.cloneFindingDescriptor.setPropertyDescription("Instances", "The number of instances of the clone, i.e. in how many locations in the model does the fragment exist.");
        this.cloneFindingDescriptor.setPropertyDescription("Size", "The size of the clone, i.e. how many statements are duplicated.");
        this.autoExpose();
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(SimulinkCoverableBlockCountIndex.class);
        proxy.createProjectIndex(SimulinkCloneFragmentIndex.class);
        proxy.createProjectIndex(InvertedSimulinkCloneFragmentIndex.class);
        proxy.createProjectIndex(SimulinkCloneChangeIndex.class);
        if (!this.cloneFindingDescriptor.getEnablement().isEnabled() && !this.cloneCoverageMetric.isMetricEnabled()) {
            return;
        }
        this.createCloneCoverageMetric(proxy);
        proxy.addFindingsSchemaEntry("Redundancy", "Model Clones", this.cloneFindingDescriptor);
        this.createTriggers(proxy);
    }

    private void createCloneCoverageMetric(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (!this.cloneCoverageMetric.isMetricEnabled()) {
            return;
        }
        MetricSchemaProxy schema = proxy.getCodeMetricSchema();
        schema.addNumericMetric(NON_TRIVIAL_BLOCKS_METRIC_NAME, "Non-Trivial Blocks", "Number of blocks that are not considered to be trivial by the clone detection", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addNumericMetric(CLONED_BLOCKS_METRIC_NAME, "Cloned Blocks", "Number of blocks that are part of at least one clone", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addMetric("block-clone-coverage", schema.createDivisionMetricSource(CLONED_BLOCKS_METRIC_NAME, NON_TRIVIAL_BLOCKS_METRIC_NAME), "Block Clone Coverage", "The relative amount of non-trivial blocks covered by at least one clone.", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC});
    }

    private void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(SimulinkCloneFragmentSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(SimulinkCloneFragmentInverter.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(SimulinkCloneChangeIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        TriggerBuilder detector = new TriggerBuilder(SimulinkCloneDetector.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        detector.setTriggerParameter("min-clone-size", this.cloneMinSize);
        proxy.createTrigger(detector);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!languages.contains(ELanguage.SIMULINK)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerConfigurationItems("Model Clones", "Redundancy", Arrays.asList(this.getOptionForField("cloneMinSize"), this.cloneCoverageMetric, this.cloneFindingDescriptor));
    }
}

