/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.conqat.lib.commons.io.DotNetUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AnalysisToolsConfigurationUtils {
    protected static ProcessUtils.ExecutionResult checkProgramAvailability(String executableName, String userSuppliedPath, Predicate<ProcessUtils.ExecutionResult> availabilityPredicate, boolean isDotNetTool, boolean preventJemalloc) throws ProjectConfigurationException {
        String toolPath = executableName;
        if (!StringUtils.isEmpty((String)userSuppliedPath)) {
            toolPath = userSuppliedPath;
            if (!new File(userSuppliedPath).exists()) {
                throw new ProjectConfigurationException(executableName + " not found under path: " + userSuppliedPath);
            }
        }
        try {
            ProcessUtils.ExecutionResult result;
            String[] pathAndArgument = new String[]{toolPath, "--version"};
            if (isDotNetTool) {
                result = DotNetUtils.executeDotNet((String[])pathAndArgument);
            } else {
                ProcessBuilder builder = new ProcessBuilder(pathAndArgument);
                if (preventJemalloc) {
                    AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(builder);
                }
                result = ProcessUtils.execute((ProcessBuilder)builder);
            }
            if (!availabilityPredicate.test(result)) {
                throw new ProjectConfigurationException("Could not execute %s (using path %s)\n%s".formatted(executableName, toolPath, result.toLimitedString(500)));
            }
            return result;
        }
        catch (IOException e) {
            throw new ProjectConfigurationException("Could not execute %s (using path %s): %s".formatted(executableName, toolPath, e.getMessage()), (Throwable)e);
        }
    }

    public static void preventUsageOfJemalloc(ProcessBuilder builder) {
        if (!SystemUtils.isLinux()) {
            return;
        }
        String ldPreload = System.getenv("LD_PRELOAD");
        if (ldPreload != null && ldPreload.contains("jemalloc")) {
            builder.environment().put("LD_PRELOAD", "");
        }
    }

    private AnalysisToolsConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

