/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public class ControlFlowCreator {
    private final PairList<IShallowEntityMatcher, IControlFlowRule> rules;
    private final DataFlowContext context;

    public ControlFlowCreator(DataFlowContext context, PairList<IShallowEntityMatcher, IControlFlowRule> rules) {
        this.context = context;
        this.rules = rules;
    }

    public IControlFlowRule.Result transform(List<ShallowEntity> entities) throws ConQATException {
        ControlFlowNode firstNode = null;
        IControlFlowRule.Result lastResult = null;
        int currentEntityIndex = 0;
        while (currentEntityIndex < entities.size()) {
            IControlFlowRule.Result result = this.transformEntity(entities, currentEntityIndex);
            if (result == null) {
                ++currentEntityIndex;
                continue;
            }
            CCSMAssert.isTrue((result.getNumberOfConsumedEntities() > 0 ? 1 : 0) != 0, (String)"A control flow rule must consume at least one entity");
            if (lastResult != null) {
                ControlFlowCreator.connectNodes(result, lastResult);
            }
            lastResult = result;
            if (firstNode == null) {
                firstNode = result.getEntryNode();
            }
            currentEntityIndex += result.getNumberOfConsumedEntities();
        }
        return this.createResult(entities, firstNode, lastResult);
    }

    private @Nullable IControlFlowRule.Result transformEntity(List<ShallowEntity> entities, int currentEntityIndex) throws ConQATException {
        return this.transformOneStep(entities.subList(currentEntityIndex, entities.size()));
    }

    private IControlFlowRule.Result createResult(List<ShallowEntity> entities, ControlFlowNode firstNode, IControlFlowRule.Result lastResult) {
        if (firstNode == null || lastResult == null) {
            ControlFlowNode node = this.context.createSyntheticNode();
            return new IControlFlowRule.Result(0, node, Arrays.asList(node));
        }
        return new IControlFlowRule.Result(entities.size(), firstNode, lastResult.getExitNodes(), lastResult.isInitializerCode());
    }

    public @Nullable IControlFlowRule.Result transformOneStep(List<ShallowEntity> availableEntities) throws ConQATException {
        IControlFlowRule rule = this.findApplicableRule(availableEntities);
        return rule.transform(availableEntities, this.context, this);
    }

    private static void connectNodes(IControlFlowRule.Result result, IControlFlowRule.Result lastResult) {
        for (ControlFlowNode predecessorNode : lastResult.getExitNodes()) {
            ControlFlowNode.link(predecessorNode, result.getEntryNode());
        }
    }

    private IControlFlowRule findApplicableRule(List<ShallowEntity> availableEntities) throws ConQATException {
        ShallowEntity headEntity = availableEntities.get(0);
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!((IShallowEntityMatcher)this.rules.getFirst(i)).matches(headEntity)) continue;
            return (IControlFlowRule)this.rules.getSecond(i);
        }
        throw new ConQATException(SourceCodeMessageUtils.createMessage((String)("Could not find any rule that applies to the following entity list:\n" + availableEntities.toString()), (ShallowEntity)availableEntities.get(0)));
    }
}

