/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;

public class SubConditionTreeParser {
    private final IOperatorMapper mapper;
    private final ETokenType openingParenthesisToken;
    private final ETokenType closingParenthesisToken;

    public SubConditionTreeParser(IOperatorMapper mapper, ETokenType openingParenthesisToken, ETokenType closingParenthesisToken) {
        this.mapper = mapper;
        this.openingParenthesisToken = openingParenthesisToken;
        this.closingParenthesisToken = closingParenthesisToken;
    }

    public ConditionTreeNode parse(List<IToken> originalTokens) {
        return this.parseExpression(originalTokens);
    }

    protected static List<IToken> cleanUpTokens(List<IToken> originalTokens) {
        Condition condition = new Condition(originalTokens).cleanupAllParentheses();
        return condition.getTokens();
    }

    private CounterSet<Integer> getNumberOfTopLevelOperatorsByPrecedence(List<IToken> tokens) {
        CounterSet result = new CounterSet();
        NestingAwareTokenIterator iterator = this.createNestingAwareTokenIterator(tokens);
        while (iterator.hasNext()) {
            iterator.next();
            ConditionTreeNode.EOperator operator = this.mapper.getOperator(tokens, iterator.getCurrentIndex());
            int currentPriority = this.mapper.getPrecedence(iterator, operator, tokens.get(iterator.getCurrentIndex()));
            if (currentPriority < 0) continue;
            result.inc((Object)currentPriority);
        }
        return result;
    }

    private NestingAwareTokenIterator createNestingAwareTokenIterator(List<IToken> tokens) {
        return new NestingAwareTokenIterator(tokens, 0, Collections.singletonList(this.openingParenthesisToken), Collections.singletonList(this.closingParenthesisToken));
    }

    private ConditionTreeNode parseExpression(List<IToken> tokens) {
        tokens = SubConditionTreeParser.cleanUpTokens(tokens);
        CounterSet<Integer> numberOfTopLevelOperatorsByPrecedence = this.getNumberOfTopLevelOperatorsByPrecedence(tokens);
        ArrayList<ConditionTreeNode.EOperator> operators = new ArrayList<ConditionTreeNode.EOperator>();
        ArrayList<List<IToken>> subExpressions = new ArrayList<List<IToken>>();
        int start = 0;
        NestingAwareTokenIterator iterator = this.createNestingAwareTokenIterator(tokens);
        while (iterator.hasNext()) {
            IToken token;
            iterator.next();
            ConditionTreeNode.EOperator operator = this.mapper.getOperator(tokens, iterator.getCurrentIndex());
            int currentOperatorPriority = this.mapper.getPrecedence(iterator, operator, token = tokens.get(iterator.getCurrentIndex()));
            if (!SubConditionTreeParser.isHighestPrecedence(numberOfTopLevelOperatorsByPrecedence, currentOperatorPriority)) continue;
            numberOfTopLevelOperatorsByPrecedence.dec((Object)currentOperatorPriority);
            operators.add(operator);
            subExpressions.add(tokens.subList(start, iterator.getCurrentIndex()));
            start = iterator.getCurrentIndex() + 1;
        }
        if (start == 0) {
            return this.parseNonBinaryExpression(tokens);
        }
        subExpressions.add(tokens.subList(start, tokens.size()));
        return this.parseBinaryOperatorExpression(operators, subExpressions);
    }

    private static boolean isHighestPrecedence(CounterSet<Integer> precedences, int precedence) {
        if (precedence == -1) {
            return false;
        }
        int highestPrecedence = precedences.getKeys().stream().mapToInt(Integer::intValue).min().orElse(-1);
        return precedence == highestPrecedence;
    }

    private ConditionTreeNode parseBinaryOperatorExpression(List<ConditionTreeNode.EOperator> operators, List<List<IToken>> subExpressions) {
        ConditionTreeNode root = new ConditionTreeNode();
        root.setOperator(operators.getFirst());
        ConditionTreeNode currentNode = root;
        for (int i = 0; i < operators.size(); ++i) {
            ConditionTreeNode child = this.parseExpression(subExpressions.get(i));
            ConditionTreeNode.EOperator operator = operators.get(i);
            if (operator == currentNode.getOperator()) {
                currentNode.addChild(child);
                continue;
            }
            ConditionTreeNode operatorNode = new ConditionTreeNode();
            operatorNode.setOperator(operator);
            operatorNode.addChild(child);
            currentNode.addChild(operatorNode);
            currentNode = operatorNode;
        }
        currentNode.addChild(this.parseExpression((List)CollectionUtils.getLast(subExpressions)));
        return root;
    }

    private ConditionTreeNode parseNonBinaryExpression(List<IToken> tokens) {
        tokens = SubConditionTreeParser.cleanUpTokens(tokens);
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.NOT})) {
            return this.parseNotExpression(tokens);
        }
        ConditionTreeNode node = new ConditionTreeNode();
        node.appendTokens(tokens);
        return node;
    }

    private ConditionTreeNode parseNotExpression(List<IToken> tokens) {
        ConditionTreeNode root = new ConditionTreeNode();
        root.setOperator(ConditionTreeNode.EOperator.NOT);
        ConditionTreeNode currentNode = root;
        for (int i = 1; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != ETokenType.NOT) {
                ConditionTreeNode node = this.parseExpression(SubConditionTreeParser.cleanUpTokens(tokens.subList(i, tokens.size())));
                currentNode.addChild(node);
                break;
            }
            ConditionTreeNode child = new ConditionTreeNode();
            child.setOperator(ConditionTreeNode.EOperator.NOT);
            currentNode.addChild(child);
            currentNode = child;
        }
        return root;
    }

    public static interface IOperatorMapper {
        public ConditionTreeNode.EOperator getOperator(List<IToken> var1, int var2);

        public int getPrecedence(NestingAwareTokenIterator var1, ConditionTreeNode.EOperator var2, IToken var3);
    }
}

