/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap;

import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapPatterns;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.AbapLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class AbapDefUseHeuristic
implements IDefUseHeuristic {
    private static final TokenPattern REFERENCE_DEREFERENCE_PATTERN = new TokenPattern().notPrecededBy((Object)ETokenType.ARROW).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{EnumSet.of(ETokenType.ARROW, ETokenType.ARROWSTAR)});
    private static final TokenPattern VARIABLE_READ_PATTERN = new TokenPattern().notPrecededBy((Object)ETokenType.ARROW).notPrecededBy((Object)ETokenType.PARAMETERS).notPrecededBy((Object)ETokenType.INTO).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(0);
    private static final TokenPattern INLINE_DEFINITION_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.DATA, ETokenType.FIELD_SYMBOL), ETokenType.LPAREN}).group(0).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(1).sequence(new Object[]{ETokenType.RPAREN}).group(0);
    private static final TokenPattern FIELD_SYMBOL_DEREFERENCE_PATTERN = new TokenPattern().notPrecededBy((Object)ETokenType.ASSIGNING).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_PATTERN}).group(0);
    private static final TokenPattern FIELD_SYMBOL_NON_DEREFERENCE_PATTERN = new TokenPattern().beginningOfStream().alternative(new Object[]{ETokenType.ASSIGN, ETokenType.UNASSIGN, new TokenPattern().sequence(new Object[]{ETokenType.IS}).optional(new Object[]{ETokenType.NOT}).sequence(new Object[]{ETokenType.ASSIGNED})});
    private static final TokenPattern DEFAULT_VARIABLE_ADDITON_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.DEFAULT}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0);
    private static final TokenPattern DEFAULT_VALUE_ADDITION_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.VALUE}).sequence(new Object[]{ETokenType.ETokenClass.LITERAL}).group(0);
    private static final TokenPattern TYPE_REF_TO_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.TYPE, ETokenType.REF, ETokenType.TO});
    private static final TokenPattern LIKE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LIKE}).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0), new TokenPattern().skipTo(new Object[]{ETokenType.OF, ETokenType.TO}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0)});
    private static final EnumSet<ETokenType> DEFINITION_KEYWORDS = EnumSet.of(ETokenType.DATA, ETokenType.STATICS, ETokenType.FIELD_SYMBOLS, ETokenType.FIELD_GROUPS);
    private static final TokenPattern VARIABLE_DEFINITION_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{DEFINITION_KEYWORDS}).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(0);
    private static final TokenPattern END_OF_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{DEFINITION_KEYWORDS, ETokenType.END, ETokenType.OF});
    private static final TokenPattern BEGIN_OF_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{DEFINITION_KEYWORDS, ETokenType.BEGIN, ETokenType.OF}).optional(new Object[]{AbapPatterns.IDENTIFIER_LIKE_PATTERN}).group(0);
    private static final TokenPattern STRUCT_ELEMENT_DECLARATION_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.DATA}).sequence(new Object[]{AbapPatterns.IDENTIFIER_LIKE_PATTERN}).group(0);
    private static final TokenPattern VARIABLE_OR_LITERAL_PATTERN = new TokenPattern().beginningOfStream().optional(new Object[]{AbapPatterns.FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(0).optional(new Object[]{ETokenType.ETokenClass.LITERAL}).group(1).endOfStream();
    private static final TokenPattern BEGINNING_OF_ASSIGNMENT_PATTERN = new TokenPattern().beginningOfStream().optional(new Object[]{ETokenType.COMPUTE}).optional(new Object[]{ETokenType.EXACT}).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN, EnumSet.of(ETokenType.EQ, ETokenType.CAST)});
    private final Set<String> definedVariables = new HashSet<String>();
    private final Set<String> definedVariablesOnFileScope = new HashSet<String>();
    private final Set<String> referenceVariables = new HashSet<String>();
    private final Deque<String> structDeclarationStack = new ArrayDeque<String>();
    private final List<ShallowEntity> entities;

    public AbapDefUseHeuristic(List<ShallowEntity> entities) {
        this.entities = entities;
    }

    @Override
    public VariableReadWriteInfo parseStatement(List<IToken> tokens) {
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        if (lastToken != null && lastToken.getType() == ETokenType.DOT) {
            tokens = tokens.subList(0, tokens.size() - 1);
        }
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        if (tokens.isEmpty()) {
            return info;
        }
        tokens = this.parseInlineDefinitions(tokens, info);
        this.parseReportParameterDefinitions(tokens, info);
        this.parseFieldSymbolDereferences(tokens, info);
        this.parseReferenceDereferences(tokens, info);
        this.parseMethodCalls(tokens, info);
        if (this.parseDefinition(tokens, info)) {
            return info;
        }
        if (this.parseAssignment(tokens, info)) {
            return info;
        }
        info.getReads().addAll(this.parseReads(tokens));
        return info;
    }

    private void parseMethodCalls(List<IToken> tokens, VariableReadWriteInfo info) {
        List matches = AbapPatterns.METHOD_PARAMETER_WRITES_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            for (MatchGroupElement groupElement : match.getMatchGroup(0)) {
                String variableName = LanguageFeatureParser.ABAP.normalizeVariable(groupElement.concatTokenTexts());
                if (StringUtils.isEmpty((String)variableName) || !this.isKnownVariableName(variableName)) continue;
                info.getAssignments().add(new VariableWrite(variableName));
            }
        }
    }

    private void parseReferenceDereferences(List<IToken> tokens, VariableReadWriteInfo info) {
        List matches = REFERENCE_DEREFERENCE_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variableName = LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(0));
            if (!this.isKnownVariableName(variableName)) continue;
            info.getDereferenceInfo().addDereference(match, 0);
        }
    }

    private void parseReportParameterDefinitions(List<IToken> tokens, VariableReadWriteInfo info) {
        if ((ETokenType.PARAMETERS.equals((Object)tokens.get(0).getType()) || ETokenType.PARAMETER.equals((Object)tokens.get(0).getType())) && tokens.size() > 1 && ETokenType.IDENTIFIER.equals((Object)tokens.get(1).getType())) {
            String variableName = LanguageFeatureParser.ABAP.normalizeVariable(tokens.get(1).getText());
            this.addToFileScope(variableName);
            info.getDefinitions().add(new VariableWrite(variableName));
        }
    }

    private void parseFieldSymbolDereferences(List<IToken> tokens, VariableReadWriteInfo info) {
        if (FIELD_SYMBOL_NON_DEREFERENCE_PATTERN.matchesAnywhere(tokens)) {
            return;
        }
        List matches = FIELD_SYMBOL_DEREFERENCE_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String fieldSymbol = LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(0));
            if (!this.isKnownVariableName(fieldSymbol)) continue;
            info.getDereferenceInfo().addDereference(match, 0);
        }
    }

    private List<IToken> parseInlineDefinitions(List<IToken> tokens, VariableReadWriteInfo info) {
        List matches = INLINE_DEFINITION_PATTERN.findAll(tokens);
        HashSet indicesToRemove = new HashSet();
        for (TokenPatternMatch match : matches) {
            indicesToRemove.addAll(match.groupIndices(0));
            String definedVariable = LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(1));
            this.definedVariables.add(definedVariable);
            info.getDefinitions().add(new VariableWrite(definedVariable).setEmpty());
        }
        ArrayList<IToken> purgedTokens = new ArrayList<IToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (indicesToRemove.contains(i)) continue;
            purgedTokens.add(tokens.get(i));
        }
        return purgedTokens;
    }

    private boolean parseDefinition(List<IToken> tokens, VariableReadWriteInfo info) {
        ETokenType typeOfFirstToken = tokens.get(0).getType();
        if (!DEFINITION_KEYWORDS.contains(typeOfFirstToken)) {
            return false;
        }
        if (this.tryParseBeginOrEndOfCommonPartDefinition(tokens, info)) {
            return true;
        }
        if (this.tryParseBeginOrEndOfDefinition(tokens, info)) {
            return true;
        }
        this.tryParseLikePatternDefinition(tokens, info);
        this.tryParseGeneralVariableDefinition(tokens, info, typeOfFirstToken);
        return true;
    }

    private boolean tryParseBeginOrEndOfCommonPartDefinition(List<IToken> tokens, VariableReadWriteInfo info) {
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.DATA, ETokenType.BEGIN, ETokenType.OF, ETokenType.COMMON, ETokenType.PART})) {
            List statements = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ETokenType.DOT});
            for (int i = 1; i < statements.size(); ++i) {
                this.parseDefinition((List)statements.get(i), info);
            }
            return true;
        }
        return TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.DATA, ETokenType.END, ETokenType.OF, ETokenType.COMMON, ETokenType.PART});
    }

    private void tryParseGeneralVariableDefinition(List<IToken> tokens, VariableReadWriteInfo info, ETokenType typeOfFirstToken) {
        TokenPatternMatch variableNameMatch = VARIABLE_DEFINITION_PATTERN.findFirstMatch(tokens);
        if (variableNameMatch == null) {
            return;
        }
        String variableName = LanguageFeatureParser.ABAP.normalizeVariable(variableNameMatch.groupString(0));
        this.definedVariables.add(variableName);
        boolean isReferenceDeclaration = TYPE_REF_TO_PATTERN.matchesAnywhere(tokens);
        if (isReferenceDeclaration) {
            this.referenceVariables.add(variableName);
        }
        VariableWrite write = new VariableWrite(variableName).setEmpty();
        write.makeDefaultInitialization();
        if (typeOfFirstToken == ETokenType.FIELD_SYMBOLS || isReferenceDeclaration) {
            write.setNull();
            write.makeDefaultInitialization();
        }
        TokenPatternMatch valueMatch = DEFAULT_VALUE_ADDITION_PATTERN.findFirstMatch(tokens);
        TokenPatternMatch variableMatch = DEFAULT_VARIABLE_ADDITON_PATTERN.findFirstMatch(tokens);
        if (typeOfFirstToken == ETokenType.STATICS) {
            write.setOther();
        } else if (valueMatch != null) {
            write.setValue(valueMatch.groupString(0));
        } else if (variableMatch != null) {
            write.setVariable(LanguageFeatureParser.ABAP.normalizeVariable(variableMatch.groupString(0)));
        }
        info.getDefinitions().add(write);
    }

    private void tryParseLikePatternDefinition(List<IToken> tokens, VariableReadWriteInfo info) {
        String variable;
        TokenPatternMatch likeMatch = LIKE_PATTERN.findFirstMatch(tokens);
        if (likeMatch != null && this.isKnownVariableName(variable = LanguageFeatureParser.ABAP.normalizeVariable(likeMatch.groupString(0)))) {
            info.getReads().add(variable);
        }
    }

    private boolean tryParseBeginOrEndOfDefinition(List<IToken> tokens, VariableReadWriteInfo info) {
        TokenPatternMatch structElementMatch;
        if (END_OF_PATTERN.matchAtStartOf(tokens) != null) {
            this.structDeclarationStack.pop();
            return true;
        }
        TokenPatternMatch beginOfMatch = BEGIN_OF_PATTERN.matchAtStartOf(tokens);
        if (beginOfMatch != null) {
            this.parseBeginOfStruct(tokens, info, beginOfMatch);
            return true;
        }
        if (!this.structDeclarationStack.isEmpty() && (structElementMatch = STRUCT_ELEMENT_DECLARATION_PATTERN.findFirstMatch(tokens)) != null) {
            this.parseDefinitionNestedInStruct(tokens, info);
            return true;
        }
        return false;
    }

    private void parseBeginOfStruct(List<IToken> tokens, VariableReadWriteInfo info, TokenPatternMatch beginOfMatch) {
        String structName = LanguageFeatureParser.ABAP.normalizeVariable(beginOfMatch.groupString(0));
        if (this.structDeclarationStack.isEmpty() && !StringUtils.isEmpty((String)structName)) {
            info.getDefinitions().add(new VariableWrite(structName));
            this.definedVariables.add(structName);
        }
        this.structDeclarationStack.push(structName);
        List statements = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ETokenType.DOT});
        for (int i = 1; i < statements.size(); ++i) {
            this.parseDefinitionNestedInStruct((List)statements.get(i), info);
        }
    }

    private void parseDefinitionNestedInStruct(List<IToken> tokens, VariableReadWriteInfo info) {
        TokenPatternMatch structElementMatch;
        TokenPatternMatch beginOfMatch;
        if (END_OF_PATTERN.matchAtStartOf(tokens) != null) {
            this.structDeclarationStack.pop();
        }
        if ((beginOfMatch = BEGIN_OF_PATTERN.matchAtStartOf(tokens)) != null) {
            this.parseBeginOfStruct(tokens, info, beginOfMatch);
            return;
        }
        if (!this.structDeclarationStack.isEmpty() && (structElementMatch = STRUCT_ELEMENT_DECLARATION_PATTERN.findFirstMatch(tokens)) != null) {
            String elementName = LanguageFeatureParser.ABAP.normalizeVariable(structElementMatch.groupString(0));
            String parentStructAccessorName = StringUtils.concat(this.structDeclarationStack.descendingIterator(), (String)"-");
            String elementAccessor = parentStructAccessorName + "-" + elementName;
            info.getDefinitions().add(new VariableWrite(elementAccessor));
            this.definedVariables.add(elementAccessor);
        }
    }

    private boolean parseAssignment(List<IToken> tokens, VariableReadWriteInfo info) {
        if (BEGINNING_OF_ASSIGNMENT_PATTERN.matchesAnywhere(tokens)) {
            this.parseAssignmentChain(tokens, info);
            return true;
        }
        Pair matchInfo = TokenUtils.getMatchingPattern(AbapPatterns.ASSIGNMENT_PATTERNS, tokens);
        if (matchInfo == null) {
            return false;
        }
        this.processAssignmentPatternMatch(tokens, info, (Pair<TokenPattern, TokenPatternMatch>)matchInfo);
        return true;
    }

    private void processAssignmentPatternMatch(List<IToken> tokens, VariableReadWriteInfo info, Pair<TokenPattern, TokenPatternMatch> matchInfo) throws AssertionError {
        List<String> reads = this.parseReads(tokens);
        if (AbapPatterns.AssignmentGroup.OTHER_ASSIGNMENT.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseOtherAssignment(tokens, info, (TokenPatternMatch)matchInfo.getSecond(), reads);
        } else if (AbapPatterns.AssignmentGroup.ASSIGNMENT_LEFT.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseLiteralOrVariableAssignment(tokens, info, (TokenPatternMatch)matchInfo.getSecond(), reads);
        } else if (AbapPatterns.AssignmentGroup.NULLED_FIELD_SYMBOL.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseNullAssignment(info, (TokenPatternMatch)matchInfo.getSecond());
        } else if (AbapPatterns.AssignmentGroup.NULLED_REFERENCE.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseNulledReference(info, (TokenPatternMatch)matchInfo.getSecond());
        } else if (AbapPatterns.AssignmentGroup.NEW_ASSIGNMENT.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseObjectCreation(info, (TokenPatternMatch)matchInfo.getSecond());
        } else if (AbapPatterns.AssignmentGroup.EXCEPTION_ASSIGNMENT.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            this.parseExceptionAssignment(info, (TokenPatternMatch)matchInfo.getSecond());
        } else {
            CCSMAssert.fail((String)SourceCodeMessageUtils.createMessage((String)("Pattern matched but did not find any assigned identifiers.\nPattern: " + String.valueOf(matchInfo.getFirst())), tokens, null));
        }
        if (AbapPatterns.AssignmentGroup.ASSIGNMENT_COMPLEX_READ.isInMatch((TokenPatternMatch)matchInfo.getSecond())) {
            reads.addAll(AbapDefUseHeuristic.getNormalizedGroupTexts((TokenPatternMatch)matchInfo.getSecond(), AbapPatterns.AssignmentGroup.ASSIGNMENT_COMPLEX_READ.ordinal()));
        }
        info.getReads().addAll(reads);
    }

    private static List<String> getNormalizedGroupTexts(TokenPatternMatch match, int tokenPatternGroup) {
        return match.groupTexts(tokenPatternGroup).stream().map(arg_0 -> ((AbapLanguageFeatureParser)LanguageFeatureParser.ABAP).normalizeVariable(arg_0)).collect(Collectors.toList());
    }

    private void parseExceptionAssignment(VariableReadWriteInfo info, TokenPatternMatch match) {
        String writtenVariable = AbapPatterns.AssignmentGroup.EXCEPTION_ASSIGNMENT.getGroupStringFromMatch(match);
        if (this.isKnownVariableName(writtenVariable)) {
            info.getAssignments().add(new VariableWrite(writtenVariable).setValue("exception"));
        }
    }

    private void parseObjectCreation(VariableReadWriteInfo info, TokenPatternMatch match) {
        String writtenVariable = AbapPatterns.AssignmentGroup.NEW_ASSIGNMENT.getGroupStringFromMatch(match);
        if (this.isKnownVariableName(writtenVariable)) {
            info.getAssignments().add(new VariableWrite(writtenVariable).setValue("new"));
        }
    }

    private void parseNulledReference(VariableReadWriteInfo info, TokenPatternMatch match) {
        String writtenVariable = AbapPatterns.AssignmentGroup.NULLED_REFERENCE.getGroupStringFromMatch(match);
        if (this.isKnownVariableName(writtenVariable)) {
            if (this.referenceVariables.contains(writtenVariable)) {
                info.getAssignments().add(new VariableWrite(writtenVariable).setNull());
            } else {
                info.getAssignments().add(new VariableWrite(writtenVariable));
            }
        }
    }

    private void parseNullAssignment(VariableReadWriteInfo info, TokenPatternMatch match) {
        String writtenVariable = AbapPatterns.AssignmentGroup.NULLED_FIELD_SYMBOL.getGroupStringFromMatch(match);
        if (this.isKnownVariableName(writtenVariable)) {
            info.getAssignments().add(new VariableWrite(writtenVariable).setNull());
        }
    }

    private void parseLiteralOrVariableAssignment(List<IToken> tokens, VariableReadWriteInfo info, TokenPatternMatch match, List<String> reads) {
        String writtenVariable = AbapPatterns.AssignmentGroup.ASSIGNMENT_LEFT.getGroupStringFromMatch(match);
        AbapDefUseHeuristic.removeWrittenVariable(reads, writtenVariable, tokens, 0);
        if (this.isKnownVariableName(writtenVariable)) {
            VariableWrite write = new VariableWrite(writtenVariable);
            String assignedVariable = AbapPatterns.AssignmentGroup.ASSIGNMENT_RIGHT.getGroupStringFromMatch(match);
            if (this.isKnownVariableName(assignedVariable)) {
                write.setVariable(assignedVariable);
            } else if (!StringUtils.isEmpty((String)assignedVariable)) {
                write.setValue(assignedVariable);
            }
            info.getAssignments().add(write);
        }
    }

    private void parseOtherAssignment(List<IToken> tokens, VariableReadWriteInfo info, TokenPatternMatch match, List<String> reads) {
        List<String> fixedVariables = AbapDefUseHeuristic.fixFieldSymbols(match.groupTexts(AbapPatterns.AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
        for (int k = 0; k < fixedVariables.size(); ++k) {
            String variable = LanguageFeatureParser.ABAP.normalizeVariable(fixedVariables.get(k));
            AbapDefUseHeuristic.removeWrittenVariable(reads, variable, tokens, k);
            if (!this.isKnownVariableName(variable)) continue;
            info.getAssignments().add(new VariableWrite(variable));
        }
    }

    private static void removeWrittenVariable(List<String> reads, String variable, List<IToken> tokens, int variableIndex) {
        if (variableIndex == 0 && EnumSet.of(ETokenType.TRANSLATE, new ETokenType[]{ETokenType.CONDENSE, ETokenType.OVERLAY, ETokenType.REPLACE, ETokenType.SHIFT, ETokenType.APPEND}).contains(tokens.get(0).getType()) && !TokenStreamUtils.containsAny(tokens, (ETokenType[])new ETokenType[]{ETokenType.TABLE})) {
            return;
        }
        reads.remove(variable);
    }

    private static List<String> fixFieldSymbols(List<String> variables) {
        ArrayList<String> fixedVariables = new ArrayList<String>();
        ListIterator<String> iterator = variables.listIterator();
        while (iterator.hasNext()) {
            Object variable = iterator.next();
            if (((String)variable).equals(">")) continue;
            if (((String)variable).equals("<")) {
                iterator.remove();
                variable = "<" + iterator.next() + ">";
            }
            fixedVariables.add((String)variable);
        }
        return fixedVariables;
    }

    private void parseAssignmentChain(List<IToken> tokens, VariableReadWriteInfo info) {
        List parts = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.CAST});
        for (int i = 0; i < parts.size() - 1; ++i) {
            List leftSide = (List)parts.get(i);
            String leftVariable = LanguageFeatureParser.ABAP.normalizeVariable(TokenStreamTextUtils.concatTokenTexts((List)leftSide));
            List rightSide = (List)parts.get(i + 1);
            info.getReads().addAll(this.parseReads(rightSide));
            if (!this.isKnownVariableName(leftVariable)) {
                info.getReads().addAll(this.parseReads(leftSide));
                continue;
            }
            VariableWrite write = new VariableWrite(leftVariable);
            TokenPatternMatch match = VARIABLE_OR_LITERAL_PATTERN.findFirstMatch(rightSide);
            if (match != null) {
                if (match.hasGroup(0)) {
                    write.setVariable(LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(0)));
                } else if (match.hasGroup(1)) {
                    write.setValue(LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(1)));
                }
            }
            info.getAssignments().add(write);
        }
    }

    private List<String> parseReads(List<IToken> tokens) {
        ArrayList<String> identifiers = new ArrayList<String>();
        List matches = VARIABLE_READ_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variable = LanguageFeatureParser.ABAP.normalizeVariable(match.groupString(0));
            if (!this.isKnownVariableName(variable) && !variable.startsWith("<") && variable.contains("-")) {
                variable = variable.split("-")[0];
            }
            if (!this.isKnownVariableName(variable)) continue;
            identifiers.add(variable);
        }
        return identifiers;
    }

    @Override
    public boolean isKnownVariableName(String variable) {
        return this.definedVariables.contains(variable) || this.definedVariablesOnFileScope.contains(variable);
    }

    @Override
    public void addToScope(String variableName) {
        this.definedVariables.add(variableName);
    }

    @Override
    public void addToFileScope(String variableName) {
        this.definedVariablesOnFileScope.add(variableName);
    }

    @Override
    public void openNewScope() {
    }

    @Override
    public void closeCurrentScope() {
    }

    @Override
    public Set<VariableWrite> getDefinitionsInFileScope() {
        return this.definedVariablesOnFileScope.stream().map(VariableWrite::new).collect(Collectors.toSet());
    }

    @Override
    public Set<VariableWrite> getDefinitionsInLocalScope() {
        return this.definedVariables.stream().map(VariableWrite::new).collect(Collectors.toSet());
    }

    @Override
    public VariableReadWriteInfo parseParameterList(List<IToken> tokens, ShallowEntity methodEntity) {
        AbapLanguageFeatureParser featureParser = LanguageFeatureParser.ABAP;
        List parameters = null;
        if (!methodEntity.ownStartTokens().isEmpty()) {
            ShallowEntity methodDeclaration;
            String entitySubtype = methodEntity.getSubtype();
            if (entitySubtype.equals("form") || entitySubtype.equals("function")) {
                parameters = featureParser.getTypeInfoForMethodParameters(methodEntity, (List)methodEntity.ownStartTokens());
            } else if (entitySubtype.equals("method implementation") && (methodDeclaration = LanguageFeatureParser.ABAP.getMethodDeclaration(this.entities, methodEntity)) != null) {
                parameters = featureParser.getTypeInfoForMethodParameters(methodDeclaration, (List)methodDeclaration.ownStartTokens());
            }
            if (parameters != null) {
                for (TypedVariable parameter : parameters) {
                    this.addToScope(parameter.getVariableName());
                }
            }
        }
        return null;
    }
}

