/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SimpleAndChainStatementRule
implements IControlFlowRule {
    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) {
        ShallowEntity statementEntity = entities.get(0);
        List<List<IToken>> statements = SimpleAndChainStatementRule.splitCompoundStatements((List<IToken>)statementEntity.ownStartTokens());
        ControlFlowNode firstNode = null;
        ControlFlowNode lastNode = null;
        for (List<IToken> statementTokens : statements) {
            ControlFlowNode statementNode = context.createNode(statementTokens, false);
            if (firstNode == null) {
                firstNode = statementNode;
            }
            if (lastNode != null) {
                ControlFlowNode.link(lastNode, statementNode);
            }
            lastNode = statementNode;
            if (!EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT).contains(statementEntity.getType()) || !statementEntity.getSubtype().equals("data") || statementTokens.size() <= 1) continue;
            statementNode.getReadWriteInfo().getDefinitions().stream().map(def -> def.getChangedVariable()).forEach(context.getDefUseHeuristic()::addToScope);
        }
        if (entities.get(0).getType() == EShallowEntityType.ATTRIBUTE && entities.get(0).getSubtype().equals("parameters")) {
            return new IControlFlowRule.Result(1, firstNode, Arrays.asList(lastNode), true);
        }
        return new IControlFlowRule.Result(1, firstNode, Arrays.asList(lastNode));
    }

    private static List<List<IToken>> splitCompoundStatements(List<IToken> ownStartTokens) {
        int colonIndex = TokenStreamUtils.firstTokenMatching(ownStartTokens, (ITokenMatcher)ETokenType.COLON);
        if (colonIndex == -1 || ((IToken)CollectionUtils.getLast(ownStartTokens)).getType() != ETokenType.DOT) {
            return Collections.singletonList(ownStartTokens);
        }
        IToken terminatingDot = (IToken)CollectionUtils.getLast(ownStartTokens);
        List<IToken> tokensBeforeColon = ownStartTokens.subList(0, colonIndex);
        List<IToken> tokensAfterColon = ownStartTokens.subList(colonIndex + 1, ownStartTokens.size());
        List statementTails = TokenStreamUtils.split(tokensAfterColon, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
        ArrayList<List<IToken>> statements = new ArrayList<List<IToken>>();
        for (int i = 0; i < statementTails.size(); ++i) {
            List tail = (List)statementTails.get(i);
            ArrayList<IToken> tokens = new ArrayList<IToken>(tail);
            tokens.addAll(0, tokensBeforeColon);
            if (i != statementTails.size() - 1) {
                tokens.add(terminatingDot);
            }
            statements.add(tokens);
        }
        return statements;
    }
}

