/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class GotoRule
implements IControlFlowRule {
    private static final TokenPattern GOTO_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.GOTO}).alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.KEYWORD}).group(0);

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) {
        ShallowEntity entity = entities.get(0);
        UnmodifiableList tokens = entity.ownStartTokens();
        ControlFlowNode node = context.createNode((List<IToken>)tokens, false);
        String label = GotoRule.extractLabel((List<IToken>)tokens);
        context.getCodeLabelManager().addJumpNode(node, label);
        return new IControlFlowRule.Result(1, node, (List<ControlFlowNode>)CollectionUtils.emptyList());
    }

    private static String extractLabel(List<IToken> tokens) {
        TokenPatternMatch match = GOTO_PATTERN.findFirstMatch(tokens);
        CCSMAssert.isNotNull((Object)match, (String)SourceCodeMessageUtils.createMessage((String)"Found malformed goto", tokens, null));
        return match.groupString(0);
    }
}

