/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.LoopRuleBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;

public abstract class WhileRuleBase
extends LoopRuleBase {
    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity whileEntity = entities.get(0);
        List<IToken> whileTokens = this.getWhileTokens(whileEntity);
        ControlFlowNode whileNode = context.createNode(whileTokens, true);
        RuleUtils.attachLambdaGraphs(whileEntity, context, creator, whileNode);
        IControlFlowRule.Result body = this.transformChildrenWithNewLoopContext(context, creator, (List<ShallowEntity>)whileEntity.getChildren());
        ControlFlowNode.link(whileNode, body.getEntryNode());
        for (ControlFlowNode exitNode : body.getExitNodes()) {
            ControlFlowNode.link(exitNode, whileNode);
            exitNode.setContinuesWithLoopReturnEdge(true);
        }
        List<ControlFlowNode> exitNodes = this.handleContinueAndBreak(context, whileNode);
        if (!this.isInfiniteLoop(whileTokens) || WhileRuleBase.loopHasBreakJumpLabel(entities)) {
            exitNodes.add(whileNode);
        } else {
            context.getInfiniteLoopNodes().add(whileNode);
        }
        return new IControlFlowRule.Result(1, whileNode, exitNodes);
    }

    private static boolean loopHasBreakJumpLabel(List<ShallowEntity> entities) {
        if (entities.isEmpty() || entities.get(0).ownStartTokens().isEmpty()) {
            return false;
        }
        List fileTokens = entities.get(0).getAllTokensOfFile();
        if (TokenStreamUtils.getLanguage((Collection)fileTokens) != ELanguage.JAVA) {
            return false;
        }
        int firstStartTokenIndex = TokenStreamUtils.indexOfByOffset((List)fileTokens, (int)((IToken)entities.get(0).ownStartTokens().get(0)).getOffset());
        return WhileRuleBase.hasLabelBeforeLoop(fileTokens, firstStartTokenIndex) || WhileRuleBase.isLoopNestedInAnonBlock(fileTokens, firstStartTokenIndex);
    }

    private static boolean hasLabelBeforeLoop(List<IToken> fileTokens, int firstStartTokenIndex) {
        return firstStartTokenIndex > 2 && TokenStreamUtils.hasTokenTypeSequence(fileTokens, (int)(firstStartTokenIndex - 2), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COLON});
    }

    private static boolean isLoopNestedInAnonBlock(List<IToken> fileTokens, int firstStartTokenIndex) {
        return firstStartTokenIndex > 3 && TokenStreamUtils.hasTokenTypeSequence(fileTokens, (int)(firstStartTokenIndex - 3), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.LBRACE});
    }

    protected abstract List<IToken> getWhileTokens(ShallowEntity var1);

    protected abstract boolean isInfiniteLoop(List<IToken> var1);
}

