/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StringConcatenationWithNullValue
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        Optional<ShallowEntity> shallowEntity = ShallowEntityTraversalUtils.listEntitiesOfType(controlFlowGraph.getEntities(), (EShallowEntityType)EShallowEntityType.STATEMENT).stream().filter(entity -> entity.getSubtype().equals("local variable")).filter(entity -> Objects.equals(entity.getName(), variable)).findFirst();
        if (!shallowEntity.isPresent() || !StringConcatenationWithNullValue.isStringConcatenationOperand(statement, variable)) {
            return false;
        }
        Optional<VariableWrite> variableWrite = statement.getReadWriteInfo().getAssignments().stream().filter(assignment -> assignment.getChangedVariable().equals(variable)).findFirst();
        if (!variableWrite.isPresent()) {
            return false;
        }
        String variableType = LanguageFeatureParser.CS.getVariableTypeFromTokens((List)shallowEntity.get().ownStartTokens());
        return variableType.equalsIgnoreCase(ETokenType.STRING.name());
    }

    private static boolean isStringConcatenationOperand(ControlFlowNode statement, String variable) {
        List<IToken> statementTokens = statement.getTokens();
        int variableIndex = TokenStreamTextUtils.findFirst(statementTokens, (String)variable);
        int plusEqualTokenIndex = variableIndex + 1;
        return variableIndex != -1 && plusEqualTokenIndex < statementTokens.size() && statementTokens.get(plusEqualTokenIndex).getType() == ETokenType.PLUSEQ;
    }
}

