/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ProjectModule
implements Serializable,
Comparable<ProjectModule> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Set<String> sourceFiles = new HashSet<String>();
    private final Set<String> moduleReferences = new HashSet<String>();
    private final boolean transitiveReferences;
    private final boolean includeAllSourcesFromContainingDirectory;

    public ProjectModule(String name, Collection<String> sourceFiles, Collection<String> moduleReferences, boolean includeAllSourcesFromContainingDirectory, boolean transitiveReferences) {
        this.name = name;
        this.sourceFiles.addAll(sourceFiles);
        this.moduleReferences.addAll(moduleReferences);
        this.includeAllSourcesFromContainingDirectory = includeAllSourcesFromContainingDirectory;
        this.transitiveReferences = transitiveReferences;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getSourceFiles() {
        return CollectionUtils.asUnmodifiable(this.sourceFiles);
    }

    public Set<String> getModuleReferences() {
        return CollectionUtils.asUnmodifiable(this.moduleReferences);
    }

    public boolean isIncludeAllSourcesFromContainingDirectory() {
        return this.includeAllSourcesFromContainingDirectory;
    }

    public boolean isTransitiveReferences() {
        return this.transitiveReferences;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectModule) {
            ProjectModule other = (ProjectModule)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ProjectModule other) {
        return this.name.compareTo(other.name);
    }
}

