/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="abap-third-party-paths", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class AbapThirdPartyPathsIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "abap-third-party-paths";
    private static final String KEY_SEPARATOR = "!=!";
    private final ValueIndex<String> delegate;

    public AbapThirdPartyPathsIndex(IStore store) {
        this.delegate = ValueIndex.forString((IStore)store);
    }

    public static String buildKey(EAbapObjectType objectType, String objectName) {
        return objectType.name() + KEY_SEPARATOR + objectName.toUpperCase();
    }

    public static EAbapObjectType getObjectType(String key) {
        return EAbapObjectType.valueOf((String)key.substring(0, key.indexOf(KEY_SEPARATOR)));
    }

    public static String getObjectName(String key) {
        return key.substring(key.indexOf(KEY_SEPARATOR) + KEY_SEPARATOR.length());
    }

    void removeEntriesForObjectTypes(Set<EAbapObjectType> keySet) throws StorageException {
        List keysWithSeparator = CollectionUtils.map(keySet, objectType -> objectType.name() + KEY_SEPARATOR);
        this.delegate.removeEntriesStartingWith(keysWithSeparator);
    }

    Map<EAbapObjectType, Map<String, String>> getAllKeysForTypes(Set<EAbapObjectType> objectTypes) throws StorageException {
        List keyPrefixes = objectTypes.stream().map(type -> type.name() + KEY_SEPARATOR).collect(Collectors.toList());
        HashMap<EAbapObjectType, Map<String, String>> result = new HashMap<EAbapObjectType, Map<String, String>>();
        for (Pair entry : this.delegate.getEntriesStartingWith(keyPrefixes)) {
            String key = (String)entry.getFirst();
            String value = (String)entry.getSecond();
            String objectTypeName = StringUtils.getFirstPart((String)key, (String)KEY_SEPARATOR);
            EAbapObjectType objectType = EAbapObjectType.getValue((String)objectTypeName);
            result.putIfAbsent(objectType, new HashMap());
            ((Map)result.get(objectType)).put(key, value);
        }
        for (EAbapObjectType type2 : objectTypes) {
            if (result.containsKey(type2)) continue;
            result.put(type2, new HashMap());
        }
        return result;
    }

    private String getThirdPartyObjectPackagePath(EAbapObjectType objectType, String objectName) throws StorageException {
        return (String)this.delegate.getValue(AbapThirdPartyPathsIndex.buildKey(objectType, objectName));
    }

    public List<String> getObjectPathsForKeys(List<String> keys) throws StorageException {
        ArrayList<String> result = new ArrayList<String>(keys.size());
        List values = this.delegate.getValues(keys);
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                result.add(null);
                continue;
            }
            result.add(AbapThirdPartyPathsIndex.formatObjectPathFromEntry(keys.get(i), (String)values.get(i)));
        }
        return result;
    }

    private static String formatObjectPathFromEntry(String key, String value) {
        return StringUtils.ensureEndsWith((String)value, (String)"/") + AbapUtils.formatAbapIdentifier((String)AbapThirdPartyPathsIndex.getObjectName(key));
    }

    Map<EAbapObjectType, String> buildThirdPartyTypeNames(String abapTypeName, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        HashMap<EAbapObjectType, String> thirdPartyTypeNames = new HashMap<EAbapObjectType, String>();
        for (EAbapObjectType objectType : possibleObjectTypes) {
            String packagePath = this.getThirdPartyObjectPackagePath(objectType, abapTypeName);
            if (packagePath == null) continue;
            thirdPartyTypeNames.put(objectType, packagePath + AbapThirdPartyPathsIndex.normalizeTypeName(abapTypeName, objectType));
        }
        return thirdPartyTypeNames;
    }

    private static String normalizeTypeName(String typeName, EAbapObjectType objectType) {
        String normalizedTypeName = AbapUtils.formatAbapIdentifier((String)typeName);
        if (objectType == EAbapObjectType.TYPE && normalizedTypeName.contains("_")) {
            normalizedTypeName = StringUtils.getFirstPart((String)normalizedTypeName, (char)'_');
        }
        return normalizedTypeName;
    }

    public void removePaths(Set<String> keysToDelete) throws StorageException {
        this.delegate.removeValues(keysToDelete);
    }

    public void setPaths(PairList<String, String> newValues) throws StorageException {
        this.delegate.setValues(newValues);
    }
}

