/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.gosu;

import com.teamscale.index.dependencies.java.JvmDependencyExtractorBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;

public class GosuDependencyExtractor
extends JvmDependencyExtractorBase {
    private int currentLine;

    public GosuDependencyExtractor() {
        super(ETokenType.DOT, ETokenType.HASH);
    }

    @Override
    protected void extractDependenciesForToken(IToken token) {
        ETokenType type;
        if (token.getLineNumber() > this.currentLine) {
            this.handleEndOfStatement();
        }
        if (this.commonCases.contains(type = token.getType())) {
            this.handleCommonCase(token);
        } else if (type == ETokenType.HASH) {
            this.handleHash(token);
        } else if (type == ETokenType.USES) {
            this.inImport = true;
        } else {
            this.handleEndOfStatement();
        }
        this.previousTokenType = token.getType();
        this.currentLine = token.getLineNumber();
    }

    private void handleHash(IToken token) {
        if (this.inIdentifier) {
            this.currentIdentifierTokens.add(token.newToken(ETokenType.DOT, token.getOffset(), token.getLineNumber(), ".", token.getOriginId()));
            if (this.inImport) {
                this.inStaticImport = true;
            }
        }
    }

    @Override
    protected void resetFieldsBeforeExtraction() {
        super.resetFieldsBeforeExtraction();
        this.currentLine = 0;
    }
}

