/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.kotlin;

import com.teamscale.index.dependencies.java.JvmDependencyExtractorBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;

public class KotlinDependencyExtractor
extends JvmDependencyExtractorBase {
    private final Map<String, String> renamedImports = new HashMap<String, String>();
    private boolean inImportAsStatement;

    public KotlinDependencyExtractor() {
        super(ETokenType.DOT);
    }

    @Override
    protected void extractDependenciesForToken(IToken token) {
        if (token.getType() == ETokenType.EOL) {
            this.handleEndOfStatement();
        } else {
            if (this.inImport && (token.getType() == ETokenType.LPAREN || token.getType() == ETokenType.RPAREN)) {
                return;
            }
            super.extractDependenciesForToken(token);
            if (token.getType() == ETokenType.AS && this.inImport) {
                this.inImportAsStatement = true;
            }
        }
    }

    @Override
    protected String resolveType(String identifier) throws ConQATException {
        boolean qualifiedIdentifier;
        boolean bl = qualifiedIdentifier = identifier.indexOf(46) != -1;
        if (!qualifiedIdentifier) {
            if (this.renamedImports.keySet().contains(identifier)) {
                return this.resolveUnqualifiedType(StringUtils.getLastPart((String)this.renamedImports.get(identifier), (String)"."));
            }
            return this.resolveUnqualifiedType(identifier);
        }
        if (this.typeLookupEnvironment.isKnownType(identifier)) {
            return identifier;
        }
        return this.resolveType(StringUtils.removeLastPart((String)identifier, (char)'.'));
    }

    @Override
    protected void resetFieldsBeforeExtraction() {
        super.resetFieldsBeforeExtraction();
        this.renamedImports.clear();
    }

    @Override
    protected void resetAtTheEndOfStatement() {
        super.resetAtTheEndOfStatement();
        this.inImportAsStatement = false;
    }

    @Override
    protected void handleIdentifier(IToken token) {
        if (this.inImportAsStatement) {
            this.renamedImports.put(token.getText(), this.getCurrentIdentifierText());
            this.handleEndOfStatement();
        } else {
            super.handleIdentifier(token);
        }
    }
}

