/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.python;

import com.teamscale.index.dependencies.TypeExtractorBase;
import com.teamscale.index.dependencies.python.PythonDependencyExtractor;
import com.teamscale.index.dependencies.type.Type;
import com.teamscale.index.resource.TokenElementIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.engine.sourcecode.shallowparser.ShallowParserUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class PythonTypeExtractor
extends TypeExtractorBase {
    private final TokenElementIndex contentIndex;
    private final Map<String, String> folderToPackageCache = new HashMap<String, String>();

    public PythonTypeExtractor(TokenElementIndex contentIndex) {
        this.contentIndex = contentIndex;
    }

    @Override
    public List<Type> extractTypes(String uniformPath, String content, ELanguage language) throws ConQATException {
        String packageName = this.getPackageForFolder(UniformPathUtils.getParentPath((String)uniformPath));
        if (PythonDependencyExtractor.isInitPy(uniformPath)) {
            return PythonTypeExtractor.getTypesForInitPy(packageName);
        }
        String pythonModule = PythonTypeExtractor.getQualifiedModuleName(packageName, uniformPath);
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ShallowEntity entity : PythonTypeExtractor.getClasses(uniformPath, content, language)) {
            typeNames.add(PythonTypeExtractor.getQualifiedName(pythonModule, entity.getName()));
        }
        typeNames.add(pythonModule);
        return PythonTypeExtractor.toTypes(typeNames);
    }

    public static String getQualifiedModuleName(String packageName, String uniformPath) {
        return PythonTypeExtractor.getQualifiedName(packageName, UniformPathUtils.getElementName((String)FileSystemUtils.getFilenameWithoutExtension((String)uniformPath)));
    }

    private static List<Type> getTypesForInitPy(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return Collections.emptyList();
        }
        return PythonTypeExtractor.toTypes(Collections.singletonList(packageName));
    }

    public static String getQualifiedName(String packageName, String name) {
        if (StringUtils.isEmpty((String)packageName)) {
            return name;
        }
        return packageName + "." + name;
    }

    private static List<ShallowEntity> getClasses(String uniformPath, String content, ELanguage language) throws ConQATException {
        List entities = ShallowParserUtils.createParser((ELanguage)language).parseTopLevel(ScannerUtils.getTokens((String)content, (ELanguage)language, (String)uniformPath));
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.TYPE);
        return CollectionUtils.filter((Collection)types, type -> type.getSubtype().equals("class"));
    }

    public String getPackageForFolder(String uniformPath) throws StorageException {
        return PythonTypeExtractor.getPackageForFolder(uniformPath, this.contentIndex, this.folderToPackageCache);
    }

    public static String getPackageForFolder(String uniformPath, TokenElementIndex contentIndex, Map<String, String> folderToPackageCache) throws StorageException {
        return PythonTypeExtractor.getPackageForFolder(uniformPath, contentIndex, folderToPackageCache, false);
    }

    private static String getPackageForFolder(String uniformPath, TokenElementIndex contentIndex, Map<String, String> folderToPackageCache, boolean requireInitPy) throws StorageException {
        String packageName;
        if (StringUtils.isEmpty((String)uniformPath)) {
            return "";
        }
        if (folderToPackageCache.containsKey(uniformPath)) {
            return folderToPackageCache.get(uniformPath);
        }
        boolean hasInitPy = PythonTypeExtractor.hasInitPy(uniformPath, contentIndex);
        if (!hasInitPy && requireInitPy) {
            packageName = "";
        } else {
            String folderName = UniformPathUtils.getElementName((String)uniformPath);
            String parentPath = UniformPathUtils.getParentPath((String)uniformPath);
            packageName = PythonTypeExtractor.getQualifiedName(PythonTypeExtractor.getPackageForFolder(parentPath, contentIndex, folderToPackageCache, hasInitPy), folderName);
            folderToPackageCache.put(uniformPath, packageName);
        }
        return packageName;
    }

    private static boolean hasInitPy(String folderUniformPath, TokenElementIndex contentIndex) throws StorageException {
        return contentIndex.getTokenElement(UniformPathUtils.concatenate((String[])new String[]{folderUniformPath, "__init__.py"})) != null;
    }

    @Override
    public List<String> getPathsToRecompute(String uniformPath, TokenElementIndex contentIndex) throws StorageException {
        ArrayList<String> pathsToRecompute = new ArrayList<String>(Collections.singleton(uniformPath));
        if (PythonDependencyExtractor.isInitPy(uniformPath)) {
            String parentPath = StringUtils.ensureEndsWith((String)UniformPathUtils.getParentPath((String)uniformPath), (String)"/");
            List<String> childPaths = contentIndex.getUniformPathsStartingWith(parentPath);
            childPaths = childPaths.stream().filter(path -> !path.equals(uniformPath) && StringUtils.stripPrefix((String)path, (String)parentPath).indexOf(47) == -1).collect(Collectors.toList());
            pathsToRecompute.addAll(childPaths);
        }
        return pathsToRecompute;
    }
}

