/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.swift;

import com.teamscale.index.dependencies.ShallowEntityTypeExtractorBase;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class SwiftLikeTypeExtractorBase
extends ShallowEntityTypeExtractorBase {
    protected abstract boolean isDeclarationOfInterfaceOrClass(ShallowEntity var1);

    @Override
    protected List<Type> extractTypes(List<ShallowEntity> entities) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(entities, (EShallowEntityType)EShallowEntityType.TYPE)) {
            if (!this.isDeclarationOfInterfaceOrClass(entity)) continue;
            String className = entity.getName();
            Optional superClassName = LanguageFeatureParser.OBJECTIVE_C.getSuperClassName(entity);
            if (superClassName.isPresent()) {
                types.add(new Type(className, List.of((String)superClassName.get())));
                continue;
            }
            types.add(new Type(className));
        }
        return types;
    }
}

