/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.external.DelayedExternalUploadIntegrationTrigger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="late.upload.schedule", name="Late External Upload Processing", type=EOptionType.SERVER, category=EOptionCategory.LIMITS)
@IndexValueClass(containedInBackup=true)
public class LateExternalUploadScheduleOption
implements IOption {
    private static final int DEFAULT_AGE_THRESHOLD = 60;
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "late.upload.schedule";
    public static final String OPTION_NAME = "Late External Upload Processing";
    @JsonProperty(value="uploadSchedule")
    @OptionFieldDescription(name="Upload schedule defining when to process uploads for old timestamps causing potentially expensive rollback operations. Leave empty for 'normal' upload processing.")
    @ScheduleOption(triggerClass=DelayedExternalUploadIntegrationTrigger.class)
    public String uploadSchedule = "";
    @JsonProperty(value="uploadAgeThreshold")
    @OptionFieldDescription(name="Age threshold in minutes defining when an upload is considered 'late'")
    public int uploadAgeThreshold = 60;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static String getUploadSchedule(ServerOptionIndex serverOptionIndex) throws StorageException {
        LateExternalUploadScheduleOption lateUploadOption = (LateExternalUploadScheduleOption)ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, LateExternalUploadScheduleOption.class, serverOptionIndex);
        if (lateUploadOption == null) {
            return null;
        }
        return lateUploadOption.uploadSchedule;
    }

    public static int getAgeThreshold(ServerOptionIndex serverOptionIndex) throws StorageException {
        LateExternalUploadScheduleOption lateUploadOption = (LateExternalUploadScheduleOption)ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, LateExternalUploadScheduleOption.class, serverOptionIndex);
        if (lateUploadOption == null) {
            return 60;
        }
        return lateUploadOption.uploadAgeThreshold;
    }
}

