/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.simulink.tracing.SimulinkCoderCodeGenerationSourceFileMapper;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkFindingLocationAdjuster {
    private final SimulinkModelInfoIndex simulinkModelInfoIndex;

    public SimulinkFindingLocationAdjuster(SimulinkModelInfoIndex simulinkModelInfoIndex) {
        this.simulinkModelInfoIndex = simulinkModelInfoIndex;
    }

    public List<DetachedFinding> correctSimulinkLocations(List<DetachedFinding> findings) {
        if (findings.isEmpty()) {
            return findings;
        }
        String path = findings.get(0).getLocation().getUniformPath();
        if (!SimulinkUtils.isSimulinkModelPath((String)path)) {
            return findings;
        }
        for (DetachedFinding finding : findings) {
            if (!(finding.getLocation() instanceof QualifiedNameLocation)) continue;
            finding.setLocation(SimulinkFindingLocationAdjuster.correctSimulinkLocation((QualifiedNameLocation)finding.getLocation(), this.simulinkModelInfoIndex));
        }
        return findings;
    }

    public static ElementLocation correctSimulinkLocation(QualifiedNameLocation location, SimulinkModelInfoIndex simulinkModelInfoIndex) {
        String id = location.getQualifiedName();
        if (id.contains(":")) {
            id = id.split(":", 2)[1];
        }
        try {
            return SimulinkCoderCodeGenerationSourceFileMapper.resolveSimulinkElementLocation(id, (ElementLocation)location, simulinkModelInfoIndex);
        }
        catch (StorageException e) {
            return new ElementLocation(location.getUniformPath());
        }
    }
}

