/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import java.util.Optional;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="external-storage-backends", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class ExternalStorageBackendIndex
implements IGlobalIndex {
    private final ValueIndex<ExternalStorageBackend> delegate;

    public ExternalStorageBackendIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setExternalStorageBackend(ExternalStorageBackend externalStorageBackend) throws StorageException {
        this.delegate.setValue(externalStorageBackend.externalStorageBackendName(), (Object)externalStorageBackend);
    }

    public Optional<ExternalStorageBackend> getExternalStorageBackend(String name) throws StorageException {
        return Optional.ofNullable((ExternalStorageBackend)this.delegate.getValue(name));
    }

    public UnmodifiableList<ExternalStorageBackend> getAllExternalStorageBackends() throws StorageException {
        return this.delegate.getAllEntries().getSecondList();
    }

    public void deleteExternalStorageBackend(ExternalStorageBackend externalStorageBackend) throws StorageException {
        this.deleteExternalStorageBackendByName(externalStorageBackend.externalStorageBackendName());
    }

    private void deleteExternalStorageBackendByName(String externalStorageBackendName) throws StorageException {
        this.delegate.removeValue(externalStorageBackendName);
    }
}

