/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.index.external.update.NodeSkippingAdjusterBase;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.engine.persistence.store.StorageException;

public class ReadjustLastNodeBeforeFirstCodeCommit
extends NodeSkippingAdjusterBase {
    public ReadjustLastNodeBeforeFirstCodeCommit(TimestampAdjustmentIndex timestampAdjustmentIndex, Map<String, Long> branchToFirstCodeCommit, Consumer<CommitTreeNode> skipListener) {
        super(branchToFirstCodeCommit, timestampAdjustmentIndex, skipListener);
    }

    @Override
    public void adjustTimestamps(List<CommitTreeNode> nodes) throws StorageException {
        List<CommitTreeNode> nodesToAdjust = this.getNodesToAdjustBottomToTop(nodes);
        Set<CommitTreeNode> nodesToMoveAfterFirstCodeCommit = this.getNodesToMoveAfterFirstCodeCommit(nodesToAdjust);
        for (CommitTreeNode node : nodesToAdjust) {
            String branchName = node.getBranchName();
            if (node.hasUnprocessedParents()) continue;
            if (nodesToMoveAfterFirstCodeCommit.contains(node)) {
                this.timestampAdjustmentIndex.adjustTimestamp((Long)this.branchToFirstCodeCommit.get(branchName) + 1L, node);
                continue;
            }
            this.adjustTimestampAndSkipIfBeforeFirstCodeCommit(node);
        }
    }

    private Set<CommitTreeNode> getNodesToMoveAfterFirstCodeCommit(List<CommitTreeNode> nodesToAdjust) {
        HashMap<String, CommitTreeNode> lastNodeBeforeCodeCommitByBranch = new HashMap<String, CommitTreeNode>();
        for (CommitTreeNode node : nodesToAdjust) {
            String branchName = node.getBranchName();
            if (!this.branchToFirstCodeCommit.containsKey(branchName) || (Long)this.branchToFirstCodeCommit.get(branchName) <= node.getOriginalTimestamp()) continue;
            lastNodeBeforeCodeCommitByBranch.merge(branchName, node, (currentLastNode, newNode) -> {
                if (currentLastNode.getOriginalTimestamp() < newNode.getOriginalTimestamp()) {
                    return newNode;
                }
                return currentLastNode;
            });
        }
        return new HashSet<CommitTreeNode>(lastNodeBeforeCodeCommitByBranch.values());
    }
}

