/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.fileloaders;

import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.fileloaders.IFileLoader;
import java.io.File;
import java.io.IOException;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public abstract class BinaryConfigurationLoaderBase
implements IFileLoader {
    @Override
    public String loadFile(File file, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration) throws IOException {
        try {
            byte[] fileContent = FileSystemUtils.readFileBinary((File)file);
            this.createConfiguration(indexLayer, fileContent);
        }
        catch (MigrationException | StorageException e) {
            throw new IOException("Failed loading configuration:" + e.getMessage(), e);
        }
        return "Successfully loaded: " + String.valueOf(file);
    }

    protected abstract void createConfiguration(IndexLayer var1, byte[] var2) throws StorageException, MigrationException;
}

