/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.utils.TempFileFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class FileToDiskWriter {
    private final TempFileFactory tempFileFactory;
    private CanonicalFile tempDirectory;

    public FileToDiskWriter(TempFileFactory tempFileFactory) {
        this.tempFileFactory = tempFileFactory;
    }

    public List<String> writeFilesToTemporaryLocation(PairList<String, String> uniformPathsAndContents) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        for (int i = 0; i < uniformPathsAndContents.size(); ++i) {
            String filename = this.writeTempFileUTF8((String)uniformPathsAndContents.getFirst(i), (String)uniformPathsAndContents.getSecond(i));
            filenames.add(filename);
        }
        return filenames;
    }

    private String writeTempFileUTF8(String uniformPath, String text) throws IOException {
        File file = this.getTempFileName(uniformPath);
        FileSystemUtils.writeFileUTF8((File)file, (String)text);
        String filename = file.getCanonicalPath();
        if (SystemUtils.isWindows()) {
            filename = FileToDiskWriter.prefixPathWithWin32LongFileWorkaround(filename);
        }
        return filename;
    }

    @VisibleForTesting
    static String prefixPathWithWin32LongFileWorkaround(String path) {
        if (path.length() > 259 && path.charAt(1) == ':') {
            return "\\\\?\\" + path;
        }
        return path;
    }

    private File getTempFileName(String uniformPath) {
        return new File((File)this.getTempDirectory(), uniformPath);
    }

    public CanonicalFile getTempDirectory() {
        if (this.tempDirectory == null) {
            this.tempDirectory = this.tempFileFactory.getTempFile(this.getClass().getSimpleName(), "");
        }
        return this.tempDirectory;
    }
}

