/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.bandit;

import com.teamscale.index.findings.bandit.BanditCheckDescription;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.string.StringUtils;

public class BanditRestructuredTextToMarkdownConverter {
    private static final List<String> KEYWORDS = List.of(":Example", ".. versionadded::", ".. versionchanged::", ".. seealso::", ":doc:");
    private static final String CODEBLOCK_DELIMITER = "```";

    private static boolean containsCheckName(String line) {
        String trim = line.trim();
        return trim.startsWith("B") || trim.startsWith("**B");
    }

    private static String getReadableName(String line) {
        return StringUtils.strip((String)line.trim(), (String)"**");
    }

    public static BanditCheckDescription convertRSTToMarkDown(String description, Map<String, String> checkNameToId) {
        StringBuilder sb = new StringBuilder();
        boolean inCodeBlock = false;
        boolean foundHeader = false;
        String readableName = null;
        for (String line : StringUtils.splitLines((String)description)) {
            if (inCodeBlock && BanditRestructuredTextToMarkdownConverter.isCodeBLockEnd(line)) {
                sb.append(CODEBLOCK_DELIMITER).append("\n");
                inCodeBlock = false;
            }
            if (!foundHeader && BanditRestructuredTextToMarkdownConverter.containsCheckName(line)) {
                readableName = BanditRestructuredTextToMarkdownConverter.getReadableName(line);
                foundHeader = true;
                continue;
            }
            if (!foundHeader && line.startsWith("=") || foundHeader && line.startsWith("=")) continue;
            line = line.replace(":Example:", "## Example");
            line = line.replace(".. seealso::", "## see also:");
            line = line.replace(".. versionadded::", "New in version ");
            line = line.replace(".. versionchanged::", "Changed in version ");
            if ((line = BanditRestructuredTextToMarkdownConverter.replaceLinksToChecks(line, checkNameToId)).contains(".. code-block::")) {
                inCodeBlock = true;
                line = "``` python";
            }
            if (BanditRestructuredTextToMarkdownConverter.isTableHeaderOrFooter(line)) continue;
            if (BanditRestructuredTextToMarkdownConverter.isTableSeparator(line)) {
                line = line.replace("+", "|").replace("=", "-");
            }
            line = line.trim();
            sb.append(line).append("\n");
        }
        if (inCodeBlock) {
            sb.append(CODEBLOCK_DELIMITER).append("\n");
        }
        return new BanditCheckDescription(readableName, sb.toString());
    }

    private static boolean isCodeBLockEnd(String line) {
        return !line.equals("") && (line.stripIndent().equals(line) || BanditRestructuredTextToMarkdownConverter.containsKeyword(line));
    }

    private static boolean isTableHeaderOrFooter(String line) {
        String trimmedLine = line.trim();
        return trimmedLine.startsWith("+-") && trimmedLine.endsWith("-+");
    }

    private static boolean isTableSeparator(String line) {
        String trimmedLine = line.trim();
        return trimmedLine.startsWith("+=") && trimmedLine.endsWith("=+");
    }

    private static String replaceLinksToChecks(String line, Map<String, String> checkNameToId) {
        String filename;
        String checkname;
        String id;
        if (line.contains(":doc:") && (id = checkNameToId.get(checkname = StringUtils.getLastPart((String)(filename = StringUtils.between((String)line, (String)"`", (String)"`")), (String)"/"))) != null) {
            return "* <a href='checks/checks/?languages=PYTHON&tools=BANDIT&rule=" + id + "'>" + checkname + "</a>";
        }
        return line;
    }

    private static boolean containsKeyword(String line) {
        return KEYWORDS.stream().anyMatch(line::contains);
    }
}

