/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.resources.Resource;
import org.jspecify.annotations.Nullable;

public class GoLangCILintRunner {
    private static final String VERSION_FILE = "version.txt";
    private static final String GOLANG_CI_LINT_EXECUTABLE = "golangci-lint";
    private static final String ENV_GOLANGCI_LINT_CACHE_DIRECTORY = "GOLANGCI_LINT_CACHE";
    private static final String ENV_GO_CACHE_DIRECTORY = "GOCACHE";
    private static final TemporaryDirectory GO_CACHE_DIR;

    public static void verifyLinterInstallation() throws GoLangCILintException {
        ExecutionResult versionResponse = GoLangCILintRunner.getLinterVersion();
        if (!versionResponse.succeeded()) {
            throw new GoLangCILintException("Could not execute GoLangCI-Lint to get its version. It is likely the linter has not been installed or it is not yet available on the system's PATH: " + versionResponse.errorsAndWarnings());
        }
        Resource resource = Resource.of(GoLangCILintRunner.class, (String)VERSION_FILE);
        String expectedVersion = resource.getContent();
        if (!versionResponse.output().trim().contains(expectedVersion.trim())) {
            throw new GoLangCILintException("Version of installed GoLangCI-Lint differs from what is expected.\nExpected version string: " + expectedVersion + "\nInstalled version string: " + versionResponse.output());
        }
    }

    private static ExecutionResult getLinterVersion() {
        return GoLangCILintRunner.runGoLangCILinter(List.of("version"), 1, null, null);
    }

    public static ExecutionResult runLinterOnFiles(CanonicalFile tempSourceDir, TemporaryDirectory tempCacheDir) {
        return GoLangCILintRunner.runGoLangCILinter(List.of("run"), 3, (File)tempSourceDir, tempCacheDir);
    }

    public static ExecutionResult getLintersListCommandLineOutput() {
        return GoLangCILintRunner.runGoLangCILinter(List.of("linters"), 1, null, null);
    }

    private static ExecutionResult runGoLangCILinter(List<String> arguments, int timeout, @Nullable File workingDirectory, @Nullable TemporaryDirectory tempCacheDir) {
        Map<String, String> environmentVariables = GoLangCILintRunner.buildEnvironmentVariables(tempCacheDir);
        ProcessWrapper process = new ProcessWrapper(GOLANG_CI_LINT_EXECUTABLE, environmentVariables, true);
        arguments.forEach(process::addArgument);
        if (workingDirectory != null) {
            process.setWorkingDirectory(workingDirectory);
        }
        StringBuffer output = new StringBuffer();
        StringBuffer errorsAndWarnings = new StringBuffer();
        process.setOutputConsumer(line -> output.append((String)line).append("\n"));
        process.setErrorConsumer(line -> errorsAndWarnings.append((String)line).append("\n"));
        int returnCode = process.runWithTimeout(timeout);
        return new ExecutionResult(returnCode, output.toString(), errorsAndWarnings.toString());
    }

    private static Map<String, String> buildEnvironmentVariables(@Nullable TemporaryDirectory cacheDir) {
        if (cacheDir == null) {
            return Map.of();
        }
        return Map.of(ENV_GOLANGCI_LINT_CACHE_DIRECTORY, cacheDir.getPath().toString(), ENV_GO_CACHE_DIRECTORY, GO_CACHE_DIR.getPath().toString());
    }

    static {
        try {
            GO_CACHE_DIR = FileSystemUtils.getTemporaryDirectoryDeletedOnShutdown((String)"teamscale-go-cache");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public record ExecutionResult(int returnCode, String output, String errorsAndWarnings) {
        public boolean succeeded() {
            return this.returnCode == 0;
        }
    }
}

