/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubernetesManifestBuilder;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntity;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntityDependency;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.io.ProcessUtils;

public class HelmChartBuilder
extends KubernetesManifestBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenElementIndexCache contentIndexCache;
    private final String helmChartPath;
    private final Pattern helmValueFilesRegexPattern;
    private final String helmValueFolder;

    public HelmChartBuilder(TokenElementIndex contentIndex, TokenElementIndexCache contentIndexCache, CommitDescriptor schedulingCommit, String helmChartPath, String helmValueFolder, Pattern helmValueFilesRegexPattern) {
        super(contentIndex, schedulingCommit);
        this.contentIndexCache = contentIndexCache;
        this.helmChartPath = helmChartPath;
        this.helmValueFilesRegexPattern = helmValueFilesRegexPattern;
        this.helmValueFolder = helmValueFolder;
    }

    @Override
    public String build() throws ConQATException {
        String yamlContent = KubernetesUtils.getContentForUniformPath(this.helmChartPath, this.contentIndexCache);
        KubernetesEntity kubernetesEntity = KubernetesUtils.readEntityContent(this.helmChartPath, yamlContent);
        HelmChartBuilder.validateChartName(kubernetesEntity, this.helmChartPath);
        List<String> chartFiles = this.getHelmChartFiles(kubernetesEntity, this.helmChartPath);
        return this.getManifestFromHelmChart(this.contentIndex.getTokenElements(chartFiles), this.helmChartPath);
    }

    private String getManifestFromHelmChart(List<TokenElementInfo> tokenElements, String uniformPath) throws ConQATException {
        String string;
        block9: {
            TemporaryDirectory tempDirectory = FileSystemUtils.getTemporaryDirectory((String)"kubernetes");
            try {
                String chartDirectory = UniformPathUtils.getParentPath((String)uniformPath);
                String tempPath = tempDirectory.getPath().toString();
                for (TokenElementInfo tokenElementInfo : tokenElements) {
                    FileSystemUtils.createFileRelativeToBaseDirectory((String)tempPath, (String)tokenElementInfo.getUniformPath(), (String)tokenElementInfo.getText());
                }
                String tempChartDirectory = UniformPathUtils.concatenate((String[])new String[]{tempPath, chartDirectory});
                List<String> additionalValueFiles = this.getAdditionalValueFiles(chartDirectory, tempDirectory.getPath().toFile(), this.helmValueFilesRegexPattern);
                List<String> helmTemplateCommand = HelmChartBuilder.getHelmCommand(tempChartDirectory, additionalValueFiles);
                List<String> helmDependencyCommand = HelmChartBuilder.getHelmDependencyCommand(tempChartDirectory);
                string = this.buildHelmChart(helmTemplateCommand, helmDependencyCommand);
                if (tempDirectory == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDirectory != null) {
                        try {
                            tempDirectory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConQATException(e.getMessage(), (Throwable)e);
                }
            }
            tempDirectory.close();
        }
        return string;
    }

    private static List<String> getHelmCommand(String path, List<String> valueFiles) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(KubernetesUtils.loadConfiguredHelmExe());
        command.add("template");
        command.add(path);
        for (String file : valueFiles) {
            command.add("-f");
            command.add(file);
        }
        return command;
    }

    private static List<String> getHelmDependencyCommand(String path) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(KubernetesUtils.loadConfiguredHelmExe());
        command.add("dependency");
        command.add("update");
        command.add(path);
        return command;
    }

    private String buildHelmChart(List<String> helmTemplateCommand, List<String> helmDependencyCommand) throws IOException {
        ProcessUtils.ExecutionResult result = KubernetesUtils.executeKubernetesProcess(helmTemplateCommand);
        Object stderror = result.getStderr();
        if (((String)stderror).contains("library charts are not installable")) {
            return "";
        }
        if (((String)stderror).contains("helm dependency build")) {
            ProcessUtils.ExecutionResult tmpResult = KubernetesUtils.executeKubernetesProcess(helmDependencyCommand);
            result = KubernetesUtils.executeKubernetesProcess(helmTemplateCommand);
            stderror = result.getStderr();
            if (!((String)stderror).isEmpty() && !tmpResult.getStderr().isEmpty()) {
                stderror = (String)stderror + " | Error loading dependency charts: " + tmpResult.getStderr();
            }
        }
        String stdout = result.getStdout();
        if (!((String)stderror).isEmpty()) {
            this.logManifestBuildError(LOGGER, stdout, (String)stderror, this.helmChartPath);
        }
        return stdout;
    }

    private List<String> getAdditionalValueFiles(String chartDirectory, File tempDirectory, Pattern helmValueFilesRegexPattern) throws StorageException {
        if (this.helmValueFolder == null) {
            return CollectionUtils.emptyList();
        }
        String prefix = !chartDirectory.isEmpty() ? UniformPathUtils.concatenate((String[])new String[]{chartDirectory, this.helmValueFolder}) : this.helmValueFolder;
        return this.contentIndex.getEntriesByPathPrefix(prefix).stream().map(ImmutablePair::getFirst).filter(path -> helmValueFilesRegexPattern.matcher(UniformPathUtils.getElementName((String)path)).matches()).map(path -> UniformPathUtils.concatenate((String[])new String[]{tempDirectory.toPath().toAbsolutePath().toString(), path})).toList();
    }

    private List<String> getHelmChartFiles(KubernetesEntity entity, String uniformPath) throws StorageException {
        String parent = UniformPathUtils.getParentPath((String)uniformPath);
        List<String> chartFiles = this.contentIndex.getUniformPathsStartingWith(parent);
        List<String> pathsOfLocalDependencyCharts = HelmChartBuilder.getPathsOfLocalDependencyCharts(entity, uniformPath);
        for (String pathOfLocalDependencyChart : pathsOfLocalDependencyCharts) {
            chartFiles.addAll(this.contentIndex.getUniformPathsStartingWith(pathOfLocalDependencyChart));
        }
        return chartFiles;
    }

    private static List<String> getPathsOfLocalDependencyCharts(KubernetesEntity entity, String uniformPath) {
        if (entity == null) {
            return CollectionUtils.emptyList();
        }
        List<KubernetesEntityDependency> dependencies = entity.getDependencies();
        if (dependencies == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<String> localDependencyPaths = new ArrayList<String>();
        String prefix = "file://";
        for (KubernetesEntityDependency dependency : dependencies) {
            String repository = dependency.getRepository();
            if (repository == null || !repository.startsWith(prefix)) continue;
            String repositoryPath = repository.substring(prefix.length());
            String resolvedRepositoryPath = UniformPathUtils.resolveRelativePath((String)uniformPath, (String)repositoryPath);
            localDependencyPaths.add(resolvedRepositoryPath);
        }
        return localDependencyPaths;
    }

    private static void validateChartName(KubernetesEntity entity, String helmChartPath) {
        String folderName = UniformPathUtils.getElementName((String)UniformPathUtils.getParentPath((String)helmChartPath));
        if (folderName.isEmpty()) {
            return;
        }
        String nameFromChartYaml = entity.getName();
        if (nameFromChartYaml == null) {
            LOGGER.error("Required property 'name' not found for Helm chart in '{}'.", (Object)folderName);
        } else if (!nameFromChartYaml.equals(folderName)) {
            LOGGER.warn("Chart name '{}' does not match folder name '{}'.", (Object)nameFromChartYaml, (Object)folderName);
        }
    }
}

