/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.phpstan.ComposerDependencyExtractor;
import com.teamscale.index.findings.phpstan.DependencyResolver;
import com.teamscale.index.findings.phpstan.PHPStanExecutor;
import com.teamscale.index.findings.phpstan.PHPStanReport;
import com.teamscale.index.findings.phpstan.PHPStanReportReader;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class PHPStanFindingSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    @VisibleForTesting
    public static final String FINDINGS_PARTITION = "phpstan-internal";
    @VisibleForTesting
    public static final String PHP_EXECUTABLE = "php";
    @VisibleForTesting
    public static final String COMPOSER_EXECUTABLE = "composer";
    public static final String ACTIVE_RULES_PARAMETER_NAME = "active-rules";
    public static final String LEVEL_PARAMETER_NAME = "level";
    public static final String IGNORE_ERRORS_PARAMETER_NAME = "ignore-errors";
    public static final String ADDITIONAL_PARAMETERS_PARAMETER_NAME = "additional-parameters";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeDependencyIndex typeDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @StepParameter(value="active-rules")
    private CodeScopeAware<Set<String>> activeRules;
    @StepParameter(value="level")
    private CodeScopeAware<Integer> level;
    @StepParameter(value="ignore-errors")
    private CodeScopeAware<List<String>> ignoreErrors;
    @StepParameter(value="additional-parameters")
    private CodeScopeAware<PairList<String, Boolean>> additionalParameters;

    public void execute() throws Exception {
        Map<CodeScopeName, Map<String, TokenElementInfo>> tokenElementsToAnalyzePerCodeScope = this.getTokenElementsToAnalyze();
        CodeScopeAware codeScopeAwareFindings = CodeScopeAware.empty();
        for (Map.Entry<CodeScopeName, Map<String, TokenElementInfo>> entry : tokenElementsToAnalyzePerCodeScope.entrySet()) {
            CodeScopeName codeScope = entry.getKey();
            Map<String, TokenElementInfo> tokenElementsToAnalyze = entry.getValue();
            List<TokenElementInfo> referencedElements = this.getAdditionalReferencedElements(tokenElementsToAnalyze);
            PHPStanReport report = this.executePhpStan(tokenElementsToAnalyze.values(), referencedElements, (Integer)this.level.getValue(codeScope), (List)this.ignoreErrors.getValue(codeScope), (PairList<String, Boolean>)((PairList)this.additionalParameters.getValue(codeScope)));
            ListMap<String, IndexFinding> findings = new PHPStanReportReader(this.pathLookupIndex.createLoggingPreloadedLookup()).parseReport(report);
            codeScopeAwareFindings.setValue(codeScope, this.filterFindings(findings, codeScope));
        }
        Set<String> analyzedPaths = tokenElementsToAnalyzePerCodeScope.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        this.synchronizeFindings((CodeScopeAware<ListMap<String, IndexFinding>>)codeScopeAwareFindings, FINDINGS_PARTITION, analyzedPaths);
    }

    private Map<CodeScopeName, Map<String, TokenElementInfo>> getTokenElementsToAnalyze() throws StorageException {
        UnmodifiableSet supportedLanguages = EAnalysisTool.PHPSTAN.getSupportedLanguages();
        return this.getContentIndexCache().getValues(this.getPossiblePathsToAnalyze()).stream().filter(Objects::nonNull).filter(element -> supportedLanguages.contains((Object)element.getLanguage())).filter(tokenElementInfo -> {
            CodeScopeName codeScope;
            CodeScopeName patt0$temp = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElementInfo);
            return patt0$temp instanceof CodeScopeName && this.activeRules.contains(codeScope = patt0$temp) && !((Set)this.activeRules.getValue(codeScope)).isEmpty();
        }).collect(Collectors.groupingBy(CodeScopeDetail::getCodeScopeNameFromTokenElement, Collectors.toMap(BasicTokenElementInfo::getUniformPath, Function.identity())));
    }

    private Set<String> getPossiblePathsToAnalyze() throws StorageException {
        List<UniformPath> changedComposerFiles = Stream.concat(this.contentDelta.getAddedOrChangedKeysAsStrings().stream(), this.contentDelta.getDeletedKeysAsStrings().stream()).filter(path -> path.endsWith("composer.json")).map(UniformPathCompatibilityUtil::convert).toList();
        HashSet<String> uniformPaths = new HashSet<String>();
        if (!changedComposerFiles.isEmpty()) {
            for (UniformPath changedComposerFile : changedComposerFiles) {
                UniformPath directory = changedComposerFile.getParent();
                uniformPaths.addAll(this.contentIndex.getUniformPathsStartingWith(directory.toString()).stream().map(UniformPathCompatibilityUtil::convert).filter(arg_0 -> ((UniformPath)directory).hasDescendant(arg_0)).map(UniformPath::toString).toList());
            }
        }
        uniformPaths.addAll(this.contentDelta.getAddedOrChangedKeysAsStrings());
        return uniformPaths;
    }

    private List<TokenElementInfo> getAdditionalReferencedElements(Map<String, TokenElementInfo> tokenElementsToAnalyze) throws StorageException {
        List<String> additionalReferencedFiles = new DependencyResolver(this.typeIndex, this.typeDependencyIndex, this.contentIndex).getAdditionalReferencedFiles(tokenElementsToAnalyze.keySet());
        return this.getContentIndexCache().getValues(additionalReferencedFiles).stream().filter(Objects::nonNull).toList();
    }

    private PHPStanReport executePhpStan(Collection<TokenElementInfo> tokenElementsToAnalyze, List<TokenElementInfo> referencedElements, int level, List<String> ignoreErrors, PairList<String, Boolean> additionalParameters) throws IOException, ConQATException {
        if (tokenElementsToAnalyze.isEmpty()) {
            return PHPStanReport.EMPTY;
        }
        try (AnalysisDirectories analysisDirectories = PHPStanFindingSynchronizer.prepareAnalysisDirectories(tokenElementsToAnalyze, referencedElements);){
            Path workingDirectory = this.prepareComposerDependencies(analysisDirectories.getAnalysisDirectory(), tokenElementsToAnalyze).map(Path::getParent).orElse(analysisDirectories.getAnalysisDirectory());
            PHPStanReport pHPStanReport = new PHPStanExecutor().execute(workingDirectory, (List<Path>)analysisDirectories.getAnalyzedFiles(), List.of(analysisDirectories.getAnalysisDirectory()), analysisDirectories.getTmpDirectory(), level, ignoreErrors, additionalParameters.toMap()).relativize(analysisDirectories.getAnalysisDirectory());
            return pHPStanReport;
        }
    }

    private Optional<Path> prepareComposerDependencies(Path path, Collection<TokenElementInfo> tokenElementsToAnalyze) throws StorageException {
        return new ComposerDependencyExtractor(this.getContentIndexCache()).prepareComposerDependencies(path, tokenElementsToAnalyze);
    }

    private static AnalysisDirectories prepareAnalysisDirectories(Collection<TokenElementInfo> tokenElementsToAnalyze, List<TokenElementInfo> referencedElements) throws IOException {
        AnalysisDirectories analysisDirectories = new AnalysisDirectories(PHPStanFindingSynchronizer.getTempDirectory((String)"TeamscalePHPStanAnalysis"));
        analysisDirectories.writeAnalysedFiles(tokenElementsToAnalyze);
        analysisDirectories.writeAdditionalFiles(referencedElements);
        Files.createDirectories(analysisDirectories.getTmpDirectory(), new FileAttribute[0]);
        return analysisDirectories;
    }

    private ListMap<String, IndexFinding> filterFindings(ListMap<String, IndexFinding> findings, CodeScopeName codeScope) {
        ListMap filteredFindings = new ListMap();
        for (Map.Entry findingEntry : findings) {
            String uniformPath = (String)findingEntry.getKey();
            Set codeScopeActiveRules = (Set)this.activeRules.getValue(codeScope);
            for (IndexFinding finding : (List)findingEntry.getValue()) {
                if (!codeScopeActiveRules.contains(finding.getGroupName())) continue;
                filteredFindings.add((Object)uniformPath, (Object)finding);
            }
        }
        return filteredFindings;
    }

    private static final class AnalysisDirectories
    implements AutoCloseable {
        private final TemporaryDirectory rootDir;
        private final Path analysisDirectory;
        private final Path tmpDirectory;
        private final List<Path> analyzedFiles = new ArrayList<Path>();

        private AnalysisDirectories(TemporaryDirectory rootDir) {
            this.rootDir = rootDir;
            this.analysisDirectory = rootDir.getPath().resolve("analysis");
            this.tmpDirectory = rootDir.getPath().resolve("tmp");
        }

        public Path getAnalysisDirectory() {
            return this.analysisDirectory;
        }

        public Path getTmpDirectory() {
            return this.tmpDirectory;
        }

        public void writeAnalysedFiles(Collection<TokenElementInfo> files) throws IOException {
            this.writeFiles(files, this.analyzedFiles::add);
        }

        public void writeAdditionalFiles(Collection<TokenElementInfo> files) throws IOException {
            this.writeFiles(files, ignored -> {});
        }

        public UnmodifiableList<Path> getAnalyzedFiles() {
            return CollectionUtils.asUnmodifiable(this.analyzedFiles);
        }

        private void writeFiles(Collection<TokenElementInfo> elementInfos, Consumer<Path> fileConsumer) throws IOException {
            for (TokenElementInfo tokenElementInfo : elementInfos) {
                Path tokenFile = this.analysisDirectory.resolve(Path.of(tokenElementInfo.getUniformPath(), new String[0]));
                fileConsumer.accept(tokenFile);
                Files.createDirectories(tokenFile.getParent(), new FileAttribute[0]);
                Files.writeString(tokenFile, (CharSequence)tokenElementInfo.getText(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }

        @Override
        public void close() throws IOException {
            this.rootDir.close();
        }
    }
}

