/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep;

import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SemgrepRuleFileLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SemgrepRuleFileLoader INSTANCE = new SemgrepRuleFileLoader();
    private static final String URL_PREFIX_FOR_GITLAB_SAST_SEMGREP_RULES = "https://gitlab.com/gitlab-org/security-products/sast-rules/-/blob/v2.8.4/";
    private final Map<String, Path> ruleFileMap = new HashMap<String, Path>();

    private SemgrepRuleFileLoader() {
        try {
            this.scanRulesDirectory();
        }
        catch (IOException e) {
            LOGGER.error("Could not load Semgrep Rule Files", (Throwable)e);
        }
    }

    private void scanRulesDirectory() throws IOException {
        Optional rulesDirectory = CheckDescriptionLoader.getDirectoryInCheckDescriptions((String)"semgrep/gitlab-sast-rules");
        if (!rulesDirectory.isPresent()) {
            LOGGER.error("Did not find any semgrep rules");
            return;
        }
        for (Path file : Files.walk((Path)rulesDirectory.get(), new FileVisitOption[0]).toList()) {
            if (!file.getFileName().toString().endsWith(".yml")) continue;
            List lines = FileSystemUtils.readLinesUTF8((Path)file);
            String id = "";
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                if (!line.trim().startsWith("- id:")) continue;
                int start = line.indexOf("- id:") + "- id:".length();
                id = StringUtils.removeDoubleQuotes((String)line.substring(start).trim().replace("\t", " "));
                break;
            }
            this.ruleFileMap.put(id, file);
        }
    }

    public static Optional<Path> getRuleFilePath(String ruleId) {
        Path resource = SemgrepRuleFileLoader.INSTANCE.ruleFileMap.get(ruleId);
        if (resource == null) {
            LOGGER.error("Could not find Semgrep rule for ID " + ruleId);
        }
        return Optional.ofNullable(resource);
    }

    public static Optional<URL> buildGitlabUrlForRuleId(String ruleId) {
        Path path = SemgrepRuleFileLoader.INSTANCE.ruleFileMap.get(ruleId);
        if (path == null) {
            return Optional.empty();
        }
        Object pathString = FileSystemUtils.normalizeSeparators((String)path.toString());
        if (!((String)pathString).contains("/gitlab-sast-rules/")) {
            return Optional.empty();
        }
        pathString = ((String)pathString).substring(((String)pathString).indexOf("/gitlab-sast-rules/") + "/gitlab-sast-rules/".length());
        pathString = URL_PREFIX_FOR_GITLAB_SAST_SEMGREP_RULES + (String)pathString;
        try {
            return Optional.of(new URL((String)pathString));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Did not specify a protocol in URL " + (String)pathString + ". Continuing without link to Semgrep rule definition.", (Throwable)e);
            return Optional.empty();
        }
    }
}

