/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentExtractor;
import com.teamscale.index.issue_reference.IssueReferenceIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.issue_reference.EIssueReferenceType;
import com.teamscale.index.resource.issue_reference.IssueReference;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CodeToReferenceMappingSynchronizerBase
extends ChangeProcessorAnalysisStep {
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    protected KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected IssueReferenceIndex issueReferenceIndex;
    @StepParameter(value="connector-id")
    protected String connectorId;
    private final TwoDimHashMap<String, String, IssueReference> issueReferencesById = new TwoDimHashMap();
    private final List<String> pathsInAddedOrChangedFilesWithNoReferences = new ArrayList<String>();

    protected PairList<String, ArrayList<IssueReference>> getUniformPathsIssueReferences(Pattern issueIdPattern) throws ConQATException {
        List<TokenElementInfo> tokenElementInfos = this.tokenElementIndex.getTokenElements(this.contentDelta.getAddedOrChangedKeysAsStrings(), true);
        PairList uniformPathsWithIssueReferences = new PairList();
        for (TokenElementInfo tokenElementInfo : tokenElementInfos) {
            if (!ShallowParserFactory.supportsLanguage((ELanguage)tokenElementInfo.getLanguage())) continue;
            this.addIssueReferencesIntoMap(issueIdPattern, tokenElementInfo);
            if (this.issueReferencesById.getSecondMap((Object)tokenElementInfo.getUniformPath()) == null) {
                this.pathsInAddedOrChangedFilesWithNoReferences.add(tokenElementInfo.getUniformPath());
                continue;
            }
            ArrayList issueReferences = new ArrayList(this.issueReferencesById.getValuesByFirstKey((Object)tokenElementInfo.getUniformPath()));
            uniformPathsWithIssueReferences.add((Object)tokenElementInfo.getUniformPath(), issueReferences);
        }
        return uniformPathsWithIssueReferences;
    }

    private void addIssueReferencesIntoMap(Pattern issueIdPattern, TokenElementInfo tokenElementInfo) throws ConQATException {
        UnmodifiableList<IToken> tokens = tokenElementInfo.getTokens();
        UnmodifiableList<ShallowEntity> entities = tokenElementInfo.getShallowEntitiesWithPreprocessorTokens();
        List<ShallowEntity> nonPreprocessedEntities = tokenElementInfo.getRawShallowEntities();
        String uniformPath = tokenElementInfo.getUniformPath();
        for (Comment comment : CommentExtractor.extractComments(tokens, tokenElementInfo, false)) {
            Map<String, List<OffsetBasedRegion>> regionsByReferenceId = CodeToReferenceMappingSynchronizerBase.getIssueReferenceRegions(comment, issueIdPattern);
            for (String issueReferenceId : regionsByReferenceId.keySet()) {
                this.createIssueReferenceForIssueReferenceIdInComment(issueReferenceId, uniformPath, regionsByReferenceId, comment, (List<ShallowEntity>)entities, nonPreprocessedEntities);
            }
        }
    }

    private static Map<String, List<OffsetBasedRegion>> getIssueReferenceRegions(Comment comment, Pattern issueIdPattern) throws ConQATException {
        Matcher matcher = issueIdPattern.matcher(comment.getRawCommentText());
        return CodeToReferenceMappingSynchronizerBase.getGroupMatches(matcher).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(region -> new OffsetBasedRegion(region.getStart(), region.getEnd())).toList()));
    }

    public static Map<String, Set<SimpleRegion>> getGroupMatches(Matcher matcher) throws ConQATException {
        if (matcher.groupCount() == 0) {
            throw new ConQATException("Expected regular expression \"%s\" to contain at least one capturing group".formatted(matcher.pattern()));
        }
        HashMap<String, Set<SimpleRegion>> result = new HashMap<String, Set<SimpleRegion>>();
        while (matcher.find()) {
            SimpleRegion region = new SimpleRegion(matcher.start(), matcher.end());
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String match = matcher.group(i);
                if (StringUtils.isEmpty((String)match)) continue;
                result.computeIfAbsent(match, key -> new HashSet()).add(region);
            }
        }
        return result;
    }

    protected abstract void createIssueReferenceForIssueReferenceIdInComment(String var1, String var2, Map<String, List<OffsetBasedRegion>> var3, Comment var4, List<ShallowEntity> var5, List<ShallowEntity> var6);

    protected void createIssueReference(String issueReferenceId, String uniformPath, Map<String, List<OffsetBasedRegion>> regionsByReferenceId, int commentOffset) {
        if (!this.issueReferencesById.containsKey((Object)uniformPath, (Object)issueReferenceId)) {
            this.issueReferencesById.putValue((Object)uniformPath, (Object)issueReferenceId, (Object)new IssueReference(new TeamscaleIssueId(this.connectorId, issueReferenceId), this.getIssueReferenceType(), uniformPath));
        }
        IssueReference issueReference = (IssueReference)this.issueReferencesById.getValue((Object)uniformPath, (Object)issueReferenceId);
        for (OffsetBasedRegion region : regionsByReferenceId.get(issueReferenceId)) {
            issueReference.addRegion(commentOffset, region);
        }
    }

    protected void storeIssueReferences(PairList<String, ArrayList<IssueReference>> uniformPathsWithIssueReferences) throws StorageException {
        HashSet<String> keysToRemove = new HashSet<String>();
        List<ArrayList<IssueReference>> references = this.issueReferenceIndex.getIssueReferences(this.pathsInAddedOrChangedFilesWithNoReferences);
        for (int i = 0; i < references.size(); ++i) {
            boolean refsOfOtherTypesAbsent;
            if (references.get(i) == null || !(refsOfOtherTypesAbsent = references.get(i).stream().allMatch(this::referenceIsFromThisSynchronizer))) continue;
            keysToRemove.add(this.pathsInAddedOrChangedFilesWithNoReferences.get(i));
        }
        this.issueReferenceIndex.setOrMergeIssueReferences(uniformPathsWithIssueReferences, (existing, replacement) -> {
            List<IssueReference> existingIssues = existing.stream().filter(Predicate.not(this::referenceIsFromThisSynchronizer)).toList();
            ArrayList<IssueReference> issueReferences = new ArrayList<IssueReference>();
            issueReferences.addAll(existingIssues);
            issueReferences.addAll((Collection<IssueReference>)replacement);
            return issueReferences;
        });
        this.issueReferenceIndex.removeIssueReferences(keysToRemove);
    }

    protected abstract EIssueReferenceType getIssueReferenceType();

    protected boolean referenceIsFromThisSynchronizer(IssueReference reference) {
        return reference.getType() == this.getIssueReferenceType() && this.connectorId.equals(reference.getId().getConnectorId());
    }

    protected void removeValuesFromIssueReferenceIndex() throws StorageException {
        List<ArrayList<IssueReference>> issueReferences = this.issueReferenceIndex.getIssueReferences(this.contentDelta.getDeletedKeysAsStrings());
        PairList updatedValues = new PairList(issueReferences.size());
        ArrayList<String> valuesToDelete = new ArrayList<String>(issueReferences.size());
        CollectionUtils.forEach((Iterable)this.contentDelta.getDeletedKeysAsStrings(), issueReferences, (key, existingReferences) -> {
            if (existingReferences == null) {
                return;
            }
            ArrayList remainingReferences = existingReferences.stream().filter(Predicate.not(this::referenceIsFromThisSynchronizer)).collect(Collectors.toCollection(ArrayList::new));
            if (remainingReferences.isEmpty()) {
                valuesToDelete.add((String)key);
            } else {
                updatedValues.add(key, (Object)remainingReferences);
            }
        });
        this.issueReferenceIndex.setIssueReferences((PairList<String, ArrayList<IssueReference>>)updatedValues);
        this.issueReferenceIndex.removeIssueReferences(valuesToDelete);
    }
}

