/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="spec-item-code-reference", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class SpecItemCodeReferenceIndex
implements IProjectIndex {
    private final ValueIndex<List<SpecItemCodeReference>> delegate;
    public static final String INDEX_NAME = "spec-item-code-reference";
    public static final String NON_EMPTY_KEY = "##non-empty##";

    public SpecItemCodeReferenceIndex(IStore store) {
        this.delegate = ValueIndex.of((IStore)store, (ISerializer)ISerializer.forSerializableList());
    }

    public Set<String> updateSpecItemCodeReferences(Set<String> updatedUniformPaths, List<TeamscaleIssueId> specItemIdsThatNeedUpdate, Map<TeamscaleIssueId, List<SpecItemCodeReference>> specItemCodeReferencesBySpecItemId) throws StorageException {
        SpecItemCodeReferenceIndexUpdate update = this.calculateSpecItemCodeReferencesUpdate(updatedUniformPaths, specItemIdsThatNeedUpdate, specItemCodeReferencesBySpecItemId);
        this.delegate.removeValues(update.requirementIdsToRemove);
        update.entriesToBeUpdated.add((Object)NON_EMPTY_KEY, new ArrayList());
        this.delegate.setValues(update.entriesToBeUpdated);
        return new HashSet<String>(update.requirementIdsToRemove);
    }

    private SpecItemCodeReferenceIndexUpdate calculateSpecItemCodeReferencesUpdate(Set<String> updatedUniformPaths, List<TeamscaleIssueId> specItemIdsThatNeedUpdate, Map<TeamscaleIssueId, List<SpecItemCodeReference>> specItemCodeReferencesBySpecItemId) throws StorageException {
        SpecItemCodeReferenceIndexUpdate update = new SpecItemCodeReferenceIndexUpdate();
        for (Pair pair : CollectionUtils.zip(specItemIdsThatNeedUpdate, (Iterable)this.delegate.getValues(specItemIdsThatNeedUpdate.stream().map(TeamscaleIssueId::getInternalId).toList()))) {
            TeamscaleIssueId specItemId = (TeamscaleIssueId)pair.getFirst();
            List specItemCodeReferences = (List)pair.getSecond();
            List<SpecItemCodeReference> updatedSpecItemCodeReferences = specItemCodeReferencesBySpecItemId.get(specItemId);
            if (specItemCodeReferences == null) {
                update.setNewSpecItemReferences(specItemId, updatedSpecItemCodeReferences);
                continue;
            }
            specItemCodeReferences.removeIf(specItemCodeReference -> updatedUniformPaths.contains(specItemCodeReference.getUniformPath()));
            if (!CollectionUtils.isNullOrEmpty(updatedSpecItemCodeReferences)) {
                specItemCodeReferences.addAll(updatedSpecItemCodeReferences);
            }
            update.setNewSpecItemReferences(specItemId, specItemCodeReferences);
        }
        return update;
    }

    public List<List<SpecItemCodeReference>> getSpecItemCodeReferences(List<String> specItemIds) throws StorageException {
        return this.delegate.getValues(specItemIds);
    }

    public Map<String, List<SpecItemCodeReference>> getSpecItemCodeReferencesBySpecItemIds(Collection<String> specItemIds) throws StorageException {
        return this.delegate.getValuesByKeys(specItemIds);
    }

    public List<SpecItemCodeReference> getSpecItemCodeReferences(String specItemId) throws StorageException {
        return (List)this.delegate.getValue(specItemId);
    }

    public PairList<String, List<SpecItemCodeReference>> getAllSpecItemCodeReferencesBySpecItemIds() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void setSpecItemCodeReferences(String specItemId, List<SpecItemCodeReference> specItemCodeReferences) throws StorageException {
        this.delegate.setValue(specItemId, specItemCodeReferences);
    }

    private static class SpecItemCodeReferenceIndexUpdate {
        private final PairList<String, List<SpecItemCodeReference>> entriesToBeUpdated = new PairList();
        private final List<String> requirementIdsToRemove = new ArrayList<String>();

        private SpecItemCodeReferenceIndexUpdate() {
        }

        private void setNewSpecItemReferences(TeamscaleIssueId specItemId, List<SpecItemCodeReference> specItemCodeReferences) {
            if (CollectionUtils.isNullOrEmpty(specItemCodeReferences)) {
                this.requirementIdsToRemove.add(specItemId.getInternalId());
            } else {
                specItemCodeReferences.sort(SpecItemCodeReference::compareTo);
                this.entriesToBeUpdated.add((Object)specItemId.getInternalId(), specItemCodeReferences);
            }
        }
    }
}

