/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.cache;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="jira-global-cache", options={EStorageOption.COMPRESSED}, valueClasses={String.class})
public class JiraGlobalCacheIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "jira-global-cache";
    private static final byte[] CONFIGURATION_COUNT_KEY = new byte[]{1};
    private static final byte[] CONFIGURATION_KEY_PREFIX = new byte[]{2};
    private static final byte[] LAST_UPDATE_TIMESTAMP_KEY_PREFIX = new byte[]{3};
    private static final byte[] ISSUE_JSON_KEY_PREFIX = new byte[]{4};
    private static final byte[] CHANGE_ENTRY_KEY_PREFIX = new byte[]{5};
    private static final byte[] LAST_CLEANUP_TIMESTAMP_KEY_PREFIX = new byte[]{6};

    public JiraGlobalCacheIndex(IStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JiraConnectionConfiguration resolveConfiguration(JiraConnectionConfiguration configuration) throws StorageException, BugTrackerException, ServiceCallException {
        byte[] key = JiraGlobalCacheIndex.makeConfigurationKey(configuration);
        byte[] value = this.store.get(key);
        if (value != null) {
            return (JiraConnectionConfiguration)StorageUtils.deserialize((byte[])value);
        }
        Lock lock = this.store.obtainLock("config");
        lock.lock();
        try {
            value = this.store.get(key);
            if (value != null) {
                JiraConnectionConfiguration jiraConnectionConfiguration = (JiraConnectionConfiguration)StorageUtils.deserialize((byte[])value);
                return jiraConnectionConfiguration;
            }
            configuration.fillMissingDataFromJira(new JiraClient(configuration.getUrl(), configuration.getUsername(), configuration.getPassword(), configuration.getCookies()));
            int configurationId = 1;
            byte[] storedCount = this.store.get(CONFIGURATION_COUNT_KEY);
            if (storedCount != null) {
                configurationId = ByteArrayUtils.byteArrayToInt((byte[])storedCount) + 1;
            }
            configuration.setConfigurationId(configurationId);
            this.store.put(CONFIGURATION_COUNT_KEY, ByteArrayUtils.intToByteArray((int)configurationId));
            this.store.put(key, StorageUtils.serialize((Serializable)configuration));
            JiraConnectionConfiguration jiraConnectionConfiguration = configuration;
            return jiraConnectionConfiguration;
        }
        finally {
            lock.unlock();
        }
    }

    private static byte[] makeConfigurationKey(JiraConnectionConfiguration configuration) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{CONFIGURATION_KEY_PREFIX, ByteArrayUtils.longToByteArray((long)configuration.getConfigurationHash())});
    }

    public List<JiraConnectionConfiguration> getAllConfigurations() throws StorageException {
        final ArrayList<JiraConnectionConfiguration> result = new ArrayList<JiraConnectionConfiguration>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                result.add((JiraConnectionConfiguration)StorageUtils.deserialize((byte[])value));
            }
        };
        this.store.scan(CONFIGURATION_KEY_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return result;
    }

    public long getLastUpdateTimestamp(int configurationId) throws StorageException {
        return this.getLastTimestampFor(LAST_UPDATE_TIMESTAMP_KEY_PREFIX, configurationId);
    }

    public void setLastUpdateTimestamp(int configurationId, long timestamp) throws StorageException {
        this.setLastTimestampFor(LAST_UPDATE_TIMESTAMP_KEY_PREFIX, configurationId, timestamp);
    }

    public long getLastCleanupTimestamp(int configurationId) throws StorageException {
        return this.getLastTimestampFor(LAST_CLEANUP_TIMESTAMP_KEY_PREFIX, configurationId);
    }

    public void setLastCleanupTimestamp(int configurationId, long timestamp) throws StorageException {
        this.setLastTimestampFor(LAST_CLEANUP_TIMESTAMP_KEY_PREFIX, configurationId, timestamp);
    }

    private long getLastTimestampFor(byte[] keyPrefix, int configurationId) throws StorageException {
        byte[] value = this.store.get(JiraGlobalCacheIndex.makeTimestampKey(keyPrefix, configurationId));
        if (value == null) {
            return 0L;
        }
        return ByteArrayUtils.byteArrayToLong((byte[])value);
    }

    private void setLastTimestampFor(byte[] keyPrefix, int configurationId, long timestamp) throws StorageException {
        this.store.put(JiraGlobalCacheIndex.makeTimestampKey(keyPrefix, configurationId), ByteArrayUtils.longToByteArray((long)timestamp));
    }

    private static byte[] makeTimestampKey(byte[] keyPrefix, int configurationId) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{keyPrefix, ByteArrayUtils.intToByteArray((int)configurationId)});
    }

    public Lock obtainCacheUpdateLock() {
        return this.store.obtainLock("cache-update");
    }

    public void updateIssueData(int configurationId, PairList<String, String> issueKeyToJson, long submissionTimestamp) throws StorageException {
        PairList keysValues = issueKeyToJson.map(key -> JiraGlobalCacheIndex.makeIssueJsonKey(configurationId, key), StringUtils::stringToBytes);
        byte[] serializedChangedIds = StorageUtils.serialize(new ArrayList(issueKeyToJson.extractFirstList()));
        byte[] semiRandomBytes = ByteArrayUtils.longToByteArray((long)XXHashUtils.xxhash64((byte[])serializedChangedIds));
        byte[] changeKey = JiraGlobalCacheIndex.makeIssueChangeKey(configurationId, submissionTimestamp, semiRandomBytes);
        keysValues.add((Object)changeKey, (Object)serializedChangedIds);
        this.store.put(keysValues);
    }

    private static byte[] makeIssueChangeKey(int configurationId, long submissionTimestamp, byte[] uniqueSuffix) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{CHANGE_ENTRY_KEY_PREFIX, ByteArrayUtils.intToByteArray((int)configurationId), ByteArrayUtils.longToByteArray((long)submissionTimestamp), uniqueSuffix});
    }

    public List<String> getIssueIdsChangedSince(int configurationId, long lastScanTimestamp) throws StorageException {
        if (lastScanTimestamp < 0L) {
            return this.getAllStoredIssueIds(configurationId);
        }
        byte[] beginKey = JiraGlobalCacheIndex.makeChangeEntryScanKey(configurationId, lastScanTimestamp);
        byte[] endKey = JiraGlobalCacheIndex.makeChangeEntryScanKey(configurationId, Long.MAX_VALUE);
        final HashSet issueIds = new HashSet();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                issueIds.addAll(StorageUtils.deserializeStringList((byte[])value));
            }
        };
        this.store.scan(beginKey, endKey, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return new ArrayList<String>(issueIds);
    }

    private static byte[] makeChangeEntryScanKey(int configurationId, long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{CHANGE_ENTRY_KEY_PREFIX, ByteArrayUtils.intToByteArray((int)configurationId), ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    public List<String> getAllStoredIssueIds(int configurationId) throws StorageException {
        ArrayList<String> issueIds = new ArrayList<String>();
        byte[] prefix = JiraGlobalCacheIndex.makePartialIssueJsonKey(configurationId);
        this.store.scanKeys(prefix, (key, unused) -> {
            List list = issueIds;
            synchronized (list) {
                issueIds.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, prefix.length, key.length)));
            }
        });
        return issueIds;
    }

    public List<String> getIssueJsonContent(int configurationId, List<String> issueIds) throws StorageException {
        List values = this.store.get(CollectionUtils.map(issueIds, id -> JiraGlobalCacheIndex.makeIssueJsonKey(configurationId, id)));
        return CollectionUtils.map((Collection)values, StringUtils::bytesToString);
    }

    private static byte[] makePartialIssueJsonKey(int configurationId) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ISSUE_JSON_KEY_PREFIX, ByteArrayUtils.intToByteArray((int)configurationId)});
    }

    private static byte[] makeIssueJsonKey(int configurationId, String issueId) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ISSUE_JSON_KEY_PREFIX, ByteArrayUtils.intToByteArray((int)configurationId), StringUtils.stringToBytes((String)issueId)});
    }

    public void clearForConfigurationId(int configurationId) throws StorageException {
        byte[] configurationIdBytes = ByteArrayUtils.intToByteArray((int)configurationId);
        this.store.removeByPrefix(ByteArrayUtils.concat((byte[][])new byte[][]{LAST_UPDATE_TIMESTAMP_KEY_PREFIX, configurationIdBytes}));
        this.store.removeByPrefix(ByteArrayUtils.concat((byte[][])new byte[][]{ISSUE_JSON_KEY_PREFIX, configurationIdBytes}));
        this.store.removeByPrefix(ByteArrayUtils.concat((byte[][])new byte[][]{CHANGE_ENTRY_KEY_PREFIX, configurationIdBytes}));
        for (JiraConnectionConfiguration configuration : this.getAllConfigurations()) {
            if (configuration.getConfigurationId() != configurationId) continue;
            this.store.remove(JiraGlobalCacheIndex.makeConfigurationKey(configuration));
        }
    }

    public void removeIssues(int configurationId, Set<String> issueIds) throws StorageException {
        List keys = CollectionUtils.map(issueIds, id -> JiraGlobalCacheIndex.makeIssueJsonKey(configurationId, id));
        this.store.remove(keys);
    }
}

