/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc.client.model;

import com.teamscale.index.issues.rtc.client.model.RtcItemRef;
import com.teamscale.index.issues.rtc.client.model.RtcRef;
import com.teamscale.index.issues.rtc.client.model.RtcReferenceType;
import org.jspecify.annotations.Nullable;

public class RtcAuditableLink {
    private String name;
    private RtcRef targetRef;
    private RtcRef sourceRef;

    public RtcAuditableLink() {
    }

    private RtcAuditableLink(String name, RtcRef targetRef, @Nullable RtcRef sourceRef) {
        this.name = name;
        this.targetRef = targetRef;
        this.sourceRef = sourceRef;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getTargetReferenceType() {
        if (this.targetRef == null || this.targetRef.referenceType == null) {
            return null;
        }
        return this.targetRef.referenceType.literal;
    }

    public @Nullable String getTargetItemId() {
        if (this.targetRef == null || this.targetRef.referencedItem == null) {
            return null;
        }
        return this.targetRef.referencedItem.itemId;
    }

    public @Nullable String getSourceItemId() {
        if (this.sourceRef == null || this.sourceRef.referencedItem == null) {
            return null;
        }
        return this.sourceRef.referencedItem.itemId;
    }

    public @Nullable String getTargetUri() {
        if (this.targetRef == null || this.targetRef.uri == null) {
            return null;
        }
        return this.targetRef.uri;
    }

    public String toString() {
        return "{Type: " + this.name + ", targetUri: " + this.getTargetUri() + ", sourceItem: " + this.getSourceItemId() + ", targetItem: " + this.getTargetItemId() + "}";
    }

    public static RtcAuditableLink createUriLink(String name, String targetUri) {
        RtcRef targetRef = new RtcRef();
        targetRef.uri = targetUri;
        RtcReferenceType referenceType = new RtcReferenceType();
        referenceType.literal = "URI_REFERENCE";
        targetRef.referenceType = referenceType;
        return new RtcAuditableLink(name, targetRef, null);
    }

    public static RtcAuditableLink createItemLink(String name, String sourceItemId, String targetItemId) {
        RtcRef targetRef = new RtcRef();
        targetRef.referencedItem = new RtcItemRef(targetItemId);
        RtcReferenceType referenceType = new RtcReferenceType();
        referenceType.literal = "ITEM_REFERENCE";
        targetRef.referenceType = referenceType;
        RtcRef sourceRef = new RtcRef();
        sourceRef.referencedItem = new RtcItemRef(sourceItemId);
        return new RtcAuditableLink(name, targetRef, sourceRef);
    }
}

