/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc.client.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.teamscale.index.issues.rtc.client.model.RtcAuditableLink;
import com.teamscale.index.issues.rtc.client.model.RtcIdAttribute;
import com.teamscale.index.issues.rtc.client.model.RtcNamedAttribute;
import com.teamscale.index.issues.rtc.client.model.RtcUser;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItemState;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class RtcWorkItem {
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSxxxx");
    public static final String TYPE_FIELD_NAME = "Type";
    @XmlAttribute
    private String href;
    private long id;
    private String summary;
    private String description;
    @VisibleForTesting
    private String itemId;
    private RtcWorkItemState state;
    private RtcUser creator;
    private RtcUser owner;
    private String creationDate;
    private String modified;
    private RtcNamedAttribute projectArea;
    private RtcNamedAttribute teamArea;
    private RtcNamedAttribute severity;
    private RtcNamedAttribute priority;
    private RtcNamedAttribute type;
    private String tags;
    private RtcIdAttribute parent;
    private PairList<String, String> customFields;
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<RtcAuditableLink> auditableLinks;

    public RtcWorkItem() {
    }

    @VisibleForTesting
    public RtcWorkItem(long id, String itemId, RtcNamedAttribute type, String href, String summary, String description, RtcWorkItemState state, RtcUser creator, RtcUser owner, String creationDate, String modified, RtcNamedAttribute severity, RtcNamedAttribute priority, String tags, @Nullable RtcIdAttribute parent) {
        this.id = id;
        this.itemId = itemId;
        this.type = type;
        this.href = href;
        this.summary = summary;
        this.description = description;
        this.state = state;
        this.creator = creator;
        this.owner = owner;
        this.creationDate = creationDate;
        this.modified = modified;
        this.severity = severity;
        this.priority = priority;
        this.tags = tags;
        this.parent = parent;
    }

    public PairList<String, String> getAllCustomAttributes() {
        PairList customAttributes = new PairList();
        if (this.customFields != null) {
            customAttributes.addAll(this.customFields);
        }
        RtcWorkItem.addAttributeIfNotNull((PairList<String, String>)customAttributes, "Severity", this.severity);
        RtcWorkItem.addAttributeIfNotNull((PairList<String, String>)customAttributes, "Priority", this.priority);
        RtcWorkItem.addAttributeIfNotNull((PairList<String, String>)customAttributes, TYPE_FIELD_NAME, this.type);
        RtcWorkItem.addAttributeIfNotNull((PairList<String, String>)customAttributes, "teamArea", this.teamArea);
        customAttributes.add((Object)"Tags", (Object)this.tags);
        return customAttributes;
    }

    private static void addAttributeIfNotNull(PairList<String, String> attributes, String name, RtcNamedAttribute attributeToAdd) {
        if (attributeToAdd != null) {
            attributes.add((Object)name, (Object)attributeToAdd.name);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getHref() {
        return this.href;
    }

    public String getOwner() {
        if (this.owner == null || this.owner.isUnassigned()) {
            return null;
        }
        return this.owner.name;
    }

    public String getCreator() {
        if (this.creator == null || this.creator.isUnassigned()) {
            return null;
        }
        return this.creator.name;
    }

    public Pair<@Nullable String, @Nullable String> getState() {
        if (this.state == null) {
            return new Pair(null, null);
        }
        return new Pair((Object)this.state.name, (Object)this.state.group);
    }

    public @Nullable String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.name;
    }

    public @Nullable String getParentId() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.id;
    }

    public List<RtcAuditableLink> getLinks() {
        if (this.auditableLinks == null) {
            return Collections.emptyList();
        }
        return List.copyOf(this.auditableLinks);
    }

    private static long parseJazzDateTimeString(String dateTimeString) {
        ZonedDateTime dateTime = ZonedDateTime.parse(dateTimeString, TIMESTAMP_FORMATTER);
        return dateTime.toInstant().toEpochMilli();
    }

    public long getCreationTimestamp() {
        return RtcWorkItem.parseJazzDateTimeString(this.creationDate);
    }

    public long getModificationTimestamp() {
        return RtcWorkItem.parseJazzDateTimeString(this.modified);
    }

    public void addCustomField(String name, String value) {
        if (this.customFields == null) {
            this.customFields = new PairList();
        }
        this.customFields.add((Object)name, (Object)value);
    }

    @VisibleForTesting
    public @Nullable PairList<String, String> getCustomFields() {
        if (this.customFields == null) {
            return null;
        }
        return new PairList(this.customFields);
    }

    @VisibleForTesting
    public @Nullable String getTeamAreaName() {
        if (this.teamArea == null) {
            return null;
        }
        return this.teamArea.name;
    }

    @VisibleForTesting
    public @Nullable String getProjectAreaName() {
        if (this.projectArea == null) {
            return null;
        }
        return this.projectArea.name;
    }

    @VisibleForTesting
    public @Nullable String getSeverity() {
        if (this.severity == null) {
            return null;
        }
        return this.severity.name;
    }

    @VisibleForTesting
    public @Nullable String getPriority() {
        if (this.priority == null) {
            return null;
        }
        return this.priority.name;
    }

    @VisibleForTesting
    public void addLink(RtcAuditableLink link) {
        if (this.auditableLinks == null) {
            this.auditableLinks = new ArrayList<RtcAuditableLink>();
        }
        this.auditableLinks.add(link);
    }
}

