/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.index.merge_request.MergeRequest;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="merge-requests", options={EStorageOption.NO_ROLLBACK}, valueClasses={MergeRequest.class, IncludeExcludeRegexSupport.class})
public class MergeRequestIndex
implements IProjectIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME = "merge-requests";
    private static final String COMMIT_TO_MERGE_REQUEST_PREFIX = "c2m";
    private static final String MERGE_REQUEST_TO_COMMIT_PREFIX = "m2c";
    private static final String BRANCH_TO_MERGE_REQUEST_PREFIX = "b2hc";
    private static final String LAST_MERGE_REQUEST_POLL_PREFIX = "lp";
    private static final String LAST_BUILD_JOB_POLL_PREFIX = "lbp";
    private static final String BUILD_PATTERNS_PREFIX = "rbp";
    private final ValueIndex<String> mergeRequestToCommitDelegateIndex;
    private final ValueIndex<MergeRequest> commitToMergeRequestDelegateIndex;
    private final ValueIndex<HashSet<String>> branchToHeadCommitDelegateIndex;
    private final ValueIndex<Long> lastMergeRequestPollDelegateIndex;
    private final ValueIndex<Long> lastBuildJobPollDelegateIndex;
    private final ValueIndex<IncludeExcludeRegexSupport> repositoryToBuildPatternsDelegateIndex;

    public MergeRequestIndex(IStore store) {
        this.mergeRequestToCommitDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, MERGE_REQUEST_TO_COMMIT_PREFIX));
        this.commitToMergeRequestDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, COMMIT_TO_MERGE_REQUEST_PREFIX));
        this.lastMergeRequestPollDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, LAST_MERGE_REQUEST_POLL_PREFIX));
        this.lastBuildJobPollDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, LAST_BUILD_JOB_POLL_PREFIX));
        this.repositoryToBuildPatternsDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, BUILD_PATTERNS_PREFIX));
        this.branchToHeadCommitDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, BRANCH_TO_MERGE_REQUEST_PREFIX));
    }

    public Optional<MergeRequest> getMergeRequest(String headCommit) throws StorageException {
        return Optional.ofNullable((MergeRequest)this.commitToMergeRequestDelegateIndex.getValue(headCommit));
    }

    public Optional<MergeRequest> getMergeRequest(MergeRequestIdentifier identifier) throws StorageException {
        Optional<String> commit = this.getHeadCommitForMergeRequest(identifier);
        if (commit.isPresent()) {
            return this.getMergeRequest(commit.get());
        }
        return Optional.empty();
    }

    public List<MergeRequest> getAllMergeRequests() throws StorageException {
        return this.commitToMergeRequestDelegateIndex.getAllEntries().extractSecondList();
    }

    public Optional<String> getHeadCommitForMergeRequest(MergeRequestIdentifier identifier) throws StorageException {
        return Optional.ofNullable((String)this.mergeRequestToCommitDelegateIndex.getValue(MergeRequestIndex.createMergeRequestKey(identifier)));
    }

    public boolean reAssociateMergeRequest(MergeRequest mergeRequest) throws StorageException {
        LOGGER.traceEntry("Re-associating merge request {}", new Object[]{mergeRequest});
        MergeRequest existingMergeRequest = this.popExistingMergeRequest(mergeRequest);
        LOGGER.trace("Popped existing merge request {}", (Object)existingMergeRequest);
        boolean needsVote = (existingMergeRequest == null || !existingMergeRequest.equals(mergeRequest)) && mergeRequest.sourceHead != null;
        this.extendMergeRequestWithChangeTimestamps(mergeRequest, existingMergeRequest, needsVote);
        this.persistMergeRequest(mergeRequest);
        LOGGER.trace("Persisted merge request {}", (Object)mergeRequest);
        return (Boolean)LOGGER.traceExit((Object)needsVote);
    }

    public @NonNull List<String> getAllSourceBranchNames() throws StorageException {
        return this.branchToHeadCommitDelegateIndex.getAllKeys();
    }

    public boolean isKnownSourceBranch(String branchName) throws StorageException {
        Set<String> headCommitsForBranch = this.getHeadCommitsForBranch(branchName);
        return !headCommitsForBranch.isEmpty();
    }

    public @NonNull Set<String> getHeadCommitsForBranch(String branch) throws StorageException {
        return this.getHeadCommitsForBranchInternally(branch);
    }

    private HashSet<String> getHeadCommitsForBranchInternally(String branch) throws StorageException {
        return Objects.requireNonNullElseGet((HashSet)this.branchToHeadCommitDelegateIndex.getValue(branch), HashSet::new);
    }

    private @Nullable MergeRequest popExistingMergeRequest(MergeRequest mergeRequest) throws StorageException {
        Optional<String> existingCommit = this.getHeadCommitForMergeRequest(mergeRequest.identifier);
        if (existingCommit.isEmpty()) {
            return null;
        }
        MergeRequest existingMergeRequest = (MergeRequest)this.commitToMergeRequestDelegateIndex.getValue(existingCommit.get());
        if (existingMergeRequest != null) {
            this.removeMergeRequestHeadCommitFromBranch(existingMergeRequest.sourceBranch, existingCommit.get());
        }
        this.commitToMergeRequestDelegateIndex.removeValue(existingCommit.get());
        return existingMergeRequest;
    }

    private void extendMergeRequestWithChangeTimestamps(MergeRequest mergeRequest, @Nullable MergeRequest existingMergeRequest, boolean needsVote) {
        if (existingMergeRequest != null) {
            mergeRequest.votingRelevantChangeTimestamps.addAll(existingMergeRequest.votingRelevantChangeTimestamps);
        }
        if (needsVote) {
            mergeRequest.votingRelevantChangeTimestamps.add(this.getMergeRequestChangeDiscoveryTime());
        }
    }

    public void addVotingRelevantChangeTimestamp(List<MergeRequest> mergeRequests) throws StorageException {
        for (MergeRequest mergeRequest : mergeRequests) {
            mergeRequest.votingRelevantChangeTimestamps.add(this.getMergeRequestChangeDiscoveryTime());
            this.persistMergeRequest(mergeRequest);
        }
    }

    @VisibleForTesting
    public void clearIndexExceptLastPollTimestamp() throws StorageException {
        this.mergeRequestToCommitDelegateIndex.removeAllEntries();
        this.commitToMergeRequestDelegateIndex.removeAllEntries();
        this.branchToHeadCommitDelegateIndex.removeAllEntries();
    }

    @VisibleForTesting
    long getMergeRequestChangeDiscoveryTime() {
        return System.currentTimeMillis();
    }

    private void persistMergeRequest(MergeRequest mergeRequest) throws StorageException {
        LOGGER.traceEntry("Persisting MergeRequest {}", new Object[]{mergeRequest.identifier});
        String headCommit = mergeRequest.sourceHead;
        String mergeRequestKey = MergeRequestIndex.createMergeRequestKey(mergeRequest.identifier);
        if (headCommit == null) {
            LOGGER.warn("Found a merge request '{}' with no head commit. This indicates that its source branch has been deleted or does not exist. It will not be shown in Teamscale.", (Object)mergeRequest.identifier);
            String previousAssociatedCommit = (String)this.mergeRequestToCommitDelegateIndex.getValue(mergeRequestKey);
            this.mergeRequestToCommitDelegateIndex.removeValue(mergeRequestKey);
            if (previousAssociatedCommit != null) {
                this.commitToMergeRequestDelegateIndex.removeValue(previousAssociatedCommit);
                this.removeMergeRequestHeadCommitFromBranch(mergeRequest.sourceBranch, previousAssociatedCommit);
            }
        } else {
            this.mergeRequestToCommitDelegateIndex.setValue(mergeRequestKey, (Object)headCommit);
            this.commitToMergeRequestDelegateIndex.setValue(headCommit, (Object)mergeRequest);
            this.addMergeRequestHeadCommitToBranch(mergeRequest.sourceBranch, headCommit);
        }
        LOGGER.traceExit(null);
    }

    private void addMergeRequestHeadCommitToBranch(String branch, String commit) throws StorageException {
        HashSet<String> values = this.getHeadCommitsForBranchInternally(branch);
        values.add(commit);
        this.branchToHeadCommitDelegateIndex.setValue(branch, values);
    }

    private void removeMergeRequestHeadCommitFromBranch(String branch, String commit) throws StorageException {
        HashSet<String> values = this.getHeadCommitsForBranchInternally(branch);
        values.remove(commit);
        if (values.isEmpty()) {
            this.branchToHeadCommitDelegateIndex.removeValue(branch);
            return;
        }
        this.branchToHeadCommitDelegateIndex.setValue(branch, values);
    }

    public void removeMergeRequest(MergeRequestIdentifier identifier) throws StorageException {
        Optional<String> existingCommit = this.getHeadCommitForMergeRequest(identifier);
        if (existingCommit.isPresent()) {
            MergeRequest mergeRequest = (MergeRequest)this.commitToMergeRequestDelegateIndex.getValue(existingCommit.get());
            if (mergeRequest == null) {
                throw new StorageException("Could not find merge request object for id %s and head commit %s during deletion of the merge request. This should never happen. Please report this error to CQSE.".formatted(identifier, existingCommit.get()));
            }
            this.removeMergeRequestHeadCommitFromBranch(mergeRequest.sourceBranch, existingCommit.get());
            this.mergeRequestToCommitDelegateIndex.removeValue(MergeRequestIndex.createMergeRequestKey(identifier));
            this.commitToMergeRequestDelegateIndex.removeValue(existingCommit.get());
        }
    }

    public static String sanitizeRepositoryName(String repositoryName) {
        return repositoryName.toLowerCase();
    }

    public Instant getLastMergeRequestPollTimestamp(String repositoryName) throws StorageException {
        return MergeRequestIndex.getLastPollTimestamp(this.lastMergeRequestPollDelegateIndex, repositoryName);
    }

    public void setLastMergeRequestPollTimestamp(String repositoryName, Instant lastPollTimestamp) throws StorageException {
        this.lastMergeRequestPollDelegateIndex.setValue(repositoryName, (Object)lastPollTimestamp.toEpochMilli());
    }

    public Instant getLastBuildJobPollTimestamp(String repositoryName) throws StorageException {
        return MergeRequestIndex.getLastPollTimestamp(this.lastBuildJobPollDelegateIndex, repositoryName);
    }

    public void setLastBuildJobPollTimestamp(String repositoryName, Instant lastPollTimestamp) throws StorageException {
        this.lastBuildJobPollDelegateIndex.setValue(repositoryName, (Object)lastPollTimestamp.toEpochMilli());
    }

    private static Instant getLastPollTimestamp(ValueIndex<Long> delegateIndex, String repositoryName) throws StorageException {
        Long value = (Long)delegateIndex.getValue(repositoryName);
        if (value == null) {
            return Instant.EPOCH;
        }
        return Instant.ofEpochMilli(value);
    }

    public @NonNull IncludeExcludeRegexSupport getConfiguredBuildPatterns(String repositoryName) throws StorageException {
        IncludeExcludeRegexSupport value = (IncludeExcludeRegexSupport)this.repositoryToBuildPatternsDelegateIndex.getValue(repositoryName);
        if (value == null) {
            return new IncludeExcludeRegexSupport();
        }
        return value;
    }

    public void setConfiguredBuildPatterns(String repositoryName, IncludeExcludeRegexSupport buildPatterns) throws StorageException {
        this.repositoryToBuildPatternsDelegateIndex.setValue(repositoryName, (Object)buildPatterns);
    }

    private static String createMergeRequestKey(MergeRequestIdentifier identifier) {
        return MergeRequestIndex.sanitizeRepositoryName(identifier.repositoryName) + "#" + identifier.id;
    }
}

