/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.teamscale.index.merge_request.comments.FindingUtils;
import com.teamscale.index.merge_request.comments.cluster.EFindingClusterType;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class FindingsForReviewComment {
    private final EFindingClusterType findingClusterType;
    private final List<TrackedFinding> findings;
    private final List<TrackedFinding> relatedFindings;

    public FindingsForReviewComment(EFindingClusterType findingClusterType, List<TrackedFinding> findings, List<TrackedFinding> relatedFindings) {
        this.findingClusterType = findingClusterType;
        this.findings = findings;
        this.relatedFindings = relatedFindings;
    }

    public UnmodifiableList<TrackedFinding> getFindings() {
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    public EFindingClusterType getFindingClusterType() {
        return this.findingClusterType;
    }

    public UnmodifiableList<TrackedFinding> getRelatedFindings() {
        return CollectionUtils.asUnmodifiable(this.relatedFindings);
    }

    public UnmodifiableList<TrackedFinding> getAllFindings() {
        return CollectionUtils.asUnmodifiable((List)CollectionUtils.unionList(this.findings, (Collection[])new Collection[]{this.relatedFindings}));
    }

    public List<TrackedFinding> getFindingsAddedInCommit(CommitDescriptor commit) {
        return this.findings.stream().filter(finding -> FindingUtils.findingWasAddedInCommit(finding, commit)).collect(Collectors.toList());
    }

    public TrackedFinding getMainFinding(CommitDescriptor commit) {
        List<TrackedFinding> newFindings = this.getFindingsAddedInCommit(commit);
        if (!newFindings.isEmpty()) {
            return FindingsForReviewComment.chooseFindingWithLowestStartLine(newFindings);
        }
        return FindingsForReviewComment.chooseFindingWithLowestStartLine(this.findings);
    }

    private static TrackedFinding chooseFindingWithLowestStartLine(List<TrackedFinding> findings) {
        return Collections.min(findings, Comparator.comparing(FindingUtils::getStartLine));
    }
}

