/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.context;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.assessment.context.MetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.PartitionUpdateType;
import com.teamscale.index.resource.retrieval_strategy.NonCodeMetricRetrievalStrategy;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class NonCodeMetricEvaluationContext
extends MetricEvaluationContext {
    private static final int MAX_UPDATE_TYPE_CACHE_ENTRIES = 20000;
    private final LoadingCache<MetricIdAndThresholdSubPath, PartitionUpdateType> partitionUpdateTypeCache = Caffeine.newBuilder().maximumSize(20000L).build(this::computePartitionUpdateType);
    private final ProjectStorageSystem projectStorageSystem;

    public NonCodeMetricEvaluationContext(String uniformPath, MetricDataRetrieverFactory metricDataRetrieverFactory, ProjectStorageSystem projectStorageSystem) {
        super(uniformPath, metricDataRetrieverFactory);
        this.projectStorageSystem = projectStorageSystem;
    }

    @Override
    public Optional<Object> getMetricValueAtCurrentHistoryAccessOption(EvaluatedMetricThreshold threshold) throws StorageException {
        if (this.canComputeMetricValue(threshold)) {
            return super.getMetricValueAtCurrentHistoryAccessOption(threshold);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Object> getMetricValueAtBaselineHistoryAccessOption(EvaluatedMetricThreshold threshold) throws StorageException {
        if (this.canComputeMetricValue(threshold)) {
            return super.getMetricValueAtBaselineHistoryAccessOption(threshold);
        }
        return Optional.empty();
    }

    private boolean canComputeMetricValue(EvaluatedMetricThreshold threshold) throws StorageException {
        if (this.baselineHistoryAccessOption == null) {
            return true;
        }
        if (threshold.getMetricSchemaSource() != EMetricSchemaSource.NON_CODE_METRICS) {
            return true;
        }
        PartitionUpdateType partitionUpdateType = this.getPartitionUpdateType(this.getMetricId(threshold), threshold.getSubPathUniformPath());
        return partitionUpdateType != PartitionUpdateType.BRANCH_HEAD_OUTDATED && partitionUpdateType != PartitionUpdateType.NO_UPDATES;
    }

    private PartitionUpdateType getPartitionUpdateType(String metricId, UniformPath thresholdSubPath) throws StorageException {
        try {
            return (PartitionUpdateType)((Object)this.partitionUpdateTypeCache.get((Object)new MetricIdAndThresholdSubPath(metricId, thresholdSubPath)));
        }
        catch (CompletionException e) {
            throw NonCodeMetricEvaluationContext.unwrapStorageException(e);
        }
    }

    private static StorageException unwrapStorageException(CompletionException completionException) {
        if (completionException.getCause() instanceof StorageException) {
            return (StorageException)completionException.getCause();
        }
        return new StorageException("Unexpected exception while computing partition update type", (Throwable)completionException);
    }

    private PartitionUpdateType computePartitionUpdateType(MetricIdAndThresholdSubPath metricIdAndThresholdSubPath) throws StorageException {
        CCSMAssert.isNotNull((Object)this.baselineHistoryAccessOption, (String)"Expected baselineHistoryAccessOption to be set");
        return PartitionUpdateType.computePartitionUpdateType(this.projectStorageSystem, this.baselineHistoryAccessOption, this.currentHistoryAccessOption, metricIdAndThresholdSubPath.metricId, metricIdAndThresholdSubPath.thresholdSubPath);
    }

    private String getMetricId(EvaluatedMetricThreshold threshold) throws StorageException {
        NonCodeMetricRetrievalStrategy nonCodeMetricRetrievalStrategy = (NonCodeMetricRetrievalStrategy)this.metricDataRetrieverFactory.get(EMetricSchemaSource.NON_CODE_METRICS).getMetricRetrievalStrategy();
        MetricDirectorySchema metricDirectorySchema = nonCodeMetricRetrievalStrategy.getMetricDirectorySchema();
        int metricValuePosition = metricDirectorySchema.getValuePosition(threshold.getMetricName());
        MetricSchemaIndex metricSchemaIndex = (MetricSchemaIndex)this.projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "process-metric-schema", HistoryAccessOption.readHeadUnbranched());
        IndexMetricSource metricSource = (IndexMetricSource)metricSchemaIndex.getMetricSources().get(metricValuePosition);
        return metricSource.getMetricPartition();
    }

    private record MetricIdAndThresholdSubPath(String metricId, UniformPath thresholdSubPath) {
    }
}

