/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.threshold;

import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;

public class MetricThresholdEvaluator {
    private final MetricThresholdConfiguration thresholdConfiguration;
    private Map<MetricThresholdIdentifier, MetricThreshold> cachedThresholdMap;

    public MetricThresholdEvaluator(@NonNull MetricThresholdConfiguration thresholdConfiguration) {
        CCSMAssert.isNotNull((Object)thresholdConfiguration);
        this.thresholdConfiguration = thresholdConfiguration;
    }

    public MetricThresholdConfiguration getThresholdConfiguration() {
        return this.thresholdConfiguration;
    }

    public Optional<EvaluatedMetricThreshold> evaluateThreshold(String thresholdDisplayName, String groupName) throws MetricThresholdConfigurationException {
        this.ensureCacheInitialized();
        MetricThresholdIdentifier thresholdIdentifier = new MetricThresholdIdentifier(groupName, thresholdDisplayName);
        MetricThreshold thresholdInCurrentConfiguration = this.cachedThresholdMap.get(thresholdIdentifier);
        if (thresholdInCurrentConfiguration == null) {
            return Optional.empty();
        }
        return Optional.of(new EvaluatedMetricThreshold(thresholdInCurrentConfiguration, thresholdInCurrentConfiguration.getThresholdYellow(), thresholdInCurrentConfiguration.getThresholdRed()));
    }

    private synchronized void ensureCacheInitialized() throws MetricThresholdConfigurationException {
        if (this.cachedThresholdMap != null) {
            return;
        }
        this.cachedThresholdMap = MetricThresholdEvaluator.createCacheForConfiguration(this.thresholdConfiguration);
    }

    private static Map<MetricThresholdIdentifier, MetricThreshold> createCacheForConfiguration(MetricThresholdConfiguration configurationEntry) throws MetricThresholdConfigurationException {
        List thresholdGroups = configurationEntry.computeTransitiveMetricThresholdGroups();
        HashMap<MetricThresholdIdentifier, MetricThreshold> result = new HashMap<MetricThresholdIdentifier, MetricThreshold>();
        for (MetricThresholdGroup group : thresholdGroups) {
            for (MetricThreshold threshold : group.getMetricThresholdList()) {
                result.put(new MetricThresholdIdentifier(group, threshold), threshold);
            }
        }
        return result;
    }
}

