/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IBatchStorageMigrator;
import com.teamscale.index.helper.ImageUtil;
import com.teamscale.index.user.EAvatarSize;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.imgscalr.Scalr;

@ThreadSafe
public class MigrateVersion151RemoveAvatarCropDimensions
implements IBatchStorageMigrator {
    private static final Logger LOGGER = LogManager.getLogger();

    public void migrate(IStore input, IStore output, IFactory<IStore, StorageException> tempStoreFactory) throws StorageException {
        if (input == null || output == null) {
            return;
        }
        Map<String, BufferedImage> userToAvatar = Collections.synchronizedMap(new HashMap());
        Map<String, Rectangle> userToCrop = Collections.synchronizedMap(new HashMap());
        MigrateVersion151RemoveAvatarCropDimensions.extractImageAndCropDimension(input, userToAvatar, userToCrop);
        MigrateVersion151RemoveAvatarCropDimensions.saveCroppedImageToOutputStore(output, userToAvatar, userToCrop);
    }

    private static void extractImageAndCropDimension(IStore input, Map<String, BufferedImage> userToAvatar, Map<String, Rectangle> userToCrop) throws StorageException {
        input.scan(new byte[0], (key, value) -> MigrateVersion151RemoveAvatarCropDimensions.scanEntries(userToAvatar, userToCrop, key, value));
    }

    private static void scanEntries(Map<String, BufferedImage> userToAvatar, Map<String, Rectangle> userToCrop, byte[] key, byte[] value) {
        if (value == null) {
            return;
        }
        String keyString = StringUtils.bytesToString((byte[])key);
        String username = StringUtils.getFirstPart((String)keyString, (char)'|');
        if (keyString.endsWith("ORIGINAL")) {
            MigrateVersion151RemoveAvatarCropDimensions.handleAvatar(userToAvatar, value, username);
        } else if (keyString.endsWith("data")) {
            MigrateVersion151RemoveAvatarCropDimensions.handleCrop(userToCrop, value, username);
        }
    }

    private static void saveCroppedImageToOutputStore(IStore output, Map<String, BufferedImage> userToAvatar, Map<String, Rectangle> userToCrop) {
        for (Map.Entry<String, BufferedImage> entry : userToAvatar.entrySet()) {
            BufferedImage avatar;
            String user = entry.getKey();
            Rectangle cropInfo = userToCrop.get(user);
            if (cropInfo == null) {
                return;
            }
            BufferedImage croppedImage = avatar = entry.getValue();
            if (cropInfo.x >= 0 && cropInfo.y >= 0 && cropInfo.width >= 0 && cropInfo.height >= 0) {
                croppedImage = Scalr.crop((BufferedImage)avatar, (int)cropInfo.x, (int)cropInfo.y, (int)cropInfo.width, (int)cropInfo.height, (BufferedImageOp[])new BufferedImageOp[0]);
            }
            for (EAvatarSize size : EAvatarSize.values()) {
                String key = user + "|" + size.name();
                byte[] keyAsBytes = StringUtils.stringToBytes((String)key);
                if (size.isThumbnail()) {
                    croppedImage = Scalr.resize((BufferedImage)croppedImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)size.getSize(), (BufferedImageOp[])new BufferedImageOp[0]);
                }
                try {
                    byte[] imageAsBytes = ImageUtil.createJpegBytes(croppedImage);
                    output.put(keyAsBytes, imageAsBytes);
                }
                catch (IOException | StorageException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    private static void handleAvatar(Map<String, BufferedImage> userToAvatar, byte[] value, String username) {
        try {
            BufferedImage parsedAvatar = ImageIO.read(new ByteArrayInputStream(value));
            userToAvatar.put(username, parsedAvatar);
        }
        catch (IOException e) {
            LOGGER.error("Could not parse avatar bytes as BufferedImage.");
        }
    }

    private static void handleCrop(Map<String, Rectangle> userToCrop, byte[] value, String username) {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            SerializedClass rectangleClass = entityPool.findClass("java.awt.Rectangle");
            for (SerializedObject entity : SerializedEntityUtils.findInstancesOf((SerializedClass)rectangleClass, (SerializedEntityPool)entityPool)) {
                Object x = entity.getFieldValue("x");
                Object y = entity.getFieldValue("y");
                Object width = entity.getFieldValue("width");
                Object height = entity.getFieldValue("height");
                if (!(x instanceof Integer && y instanceof Integer && width instanceof Integer && height instanceof Integer)) {
                    LOGGER.error("Rectangle field values are not integers, cannot parse crop.");
                    return;
                }
                Rectangle crop = new Rectangle((Integer)x, (Integer)y, (Integer)width, (Integer)height);
                userToCrop.put(username, crop);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error when trying to access serialized entity.", (Throwable)e);
        }
    }

    public String getStoreName() {
        return "avatars";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V151;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }
}

