/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.dashboard.DashboardDescriptorBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion153DefaultDashboardTemplates
implements IPointwiseStorageMigrator {
    private final String dashboardDescriptorJson1 = StringUtils.removeWhitespace((String)Resource.of(this.getClass(), (String)"version153DashboardTemplateDescriptor1.json").getContent());
    private final String dashboardDescriptorJson2 = StringUtils.removeWhitespace((String)Resource.of(this.getClass(), (String)"version153DashboardTemplateDescriptor2.json").getContent());
    private final String dashboardDescriptorJson3 = StringUtils.removeWhitespace((String)Resource.of(this.getClass(), (String)"version153DashboardTemplateDescriptor3.json").getContent());
    private final String dashboardDescriptorJson4 = StringUtils.removeWhitespace((String)Resource.of(this.getClass(), (String)"version153DashboardTemplateDescriptor4.json").getContent());
    private final String dashboardDescriptorJson5 = StringUtils.removeWhitespace((String)Resource.of(this.getClass(), (String)"version153DashboardTemplateDescriptor5.json").getContent());

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        DashboardDescriptorBase dashboardDescriptor = (DashboardDescriptorBase)StorageUtils.deserialize((byte[])LZ4Utils.decompress((byte[])value));
        if (this.isUnalteredOverviewDashboard(dashboardDescriptor)) {
            return null;
        }
        return PairList.from((Object)key, (Object)value);
    }

    private boolean isUnalteredOverviewDashboard(DashboardDescriptorBase dashboardDescriptor) {
        return dashboardDescriptor.name.equals("Overview Dashboard") && (StringUtils.removeWhitespace((String)dashboardDescriptor.getDescriptorAsJson()).equals(this.dashboardDescriptorJson1) || StringUtils.removeWhitespace((String)dashboardDescriptor.getDescriptorAsJson()).equals(this.dashboardDescriptorJson2) || StringUtils.removeWhitespace((String)dashboardDescriptor.getDescriptorAsJson()).equals(this.dashboardDescriptorJson3) || StringUtils.removeWhitespace((String)dashboardDescriptor.getDescriptorAsJson()).equals(this.dashboardDescriptorJson4) || StringUtils.removeWhitespace((String)dashboardDescriptor.getDescriptorAsJson()).equals(this.dashboardDescriptorJson5));
    }

    public String getStoreName() {
        return "dashboard-templates";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V153;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }
}

