/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion164AppleConnectOption
implements IPointwiseStorageMigrator {
    private static final String REMOVED_OPTION_PREFIX = "server:auth.apple-connect";

    public String getStoreName() {
        return "server-options";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V164;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        String optionKey = StringUtils.bytesToString((byte[])key);
        if (optionKey != null && optionKey.startsWith(REMOVED_OPTION_PREFIX)) {
            return new PairList();
        }
        return PairList.from((Object)key, (Object)value);
    }
}

