/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import java.util.Arrays;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class MigrateVersion166LastChangeTrackingValueIndex
implements IPointwiseStorageMigrator {
    private static final byte[] OLD_LAST_CHANGE_TIMESTAMP_KEY = StringUtils.stringToBytes((String)"last-change-timestamp-key");
    private static final byte[] NEW_LAST_CHANGE_TIMESTAMP_RAW_KEY = ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)"last-change-timestamp$%$"), ByteArrayUtils.intToByteArray((int)0)});
    private static final byte[] NEW_VALUE_PREFIX = StringUtils.stringToBytes((String)"values$%$");
    private static final EStorageSystemVersion VERSION = EStorageSystemVersion.STORAGE_SYSTEM_V166;
    private final String storeName;
    private final EStorageMigratorType type;

    protected MigrateVersion166LastChangeTrackingValueIndex(String storeName, EStorageMigratorType type) {
        this.storeName = storeName;
        this.type = type;
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        byte[] newKey = Arrays.equals(OLD_LAST_CHANGE_TIMESTAMP_KEY, key) ? NEW_LAST_CHANGE_TIMESTAMP_RAW_KEY : ByteArrayUtils.concat((byte[][])new byte[][]{NEW_VALUE_PREFIX, key});
        return PairList.from((Object)newKey, (Object)value);
    }

    public String getStoreName() {
        return this.storeName;
    }

    public EStorageSystemVersion getVersion() {
        return VERSION;
    }

    public EStorageMigratorType getType() {
        return this.type;
    }

    @ThreadSafe
    public static class MigrateUserRecentlyViewedProjectsIndex
    extends MigrateVersion166LastChangeTrackingValueIndex {
        public MigrateUserRecentlyViewedProjectsIndex() {
            super("user-recently-viewed-projects", EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static class MigrateUserRecentlyInteractedBranchesIndex
    extends MigrateVersion166LastChangeTrackingValueIndex {
        public MigrateUserRecentlyInteractedBranchesIndex() {
            super("user-recently-interacted-branches", EStorageMigratorType.PROJECT);
        }
    }

    @ThreadSafe
    public static class MigrateUserEventAnnouncementPreferencesIndex
    extends MigrateVersion166LastChangeTrackingValueIndex {
        public MigrateUserEventAnnouncementPreferencesIndex() {
            super("user-event-announcement-preferences", EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static class MigrateUserDashboardFavoritesIndex
    extends MigrateVersion166LastChangeTrackingValueIndex {
        public MigrateUserDashboardFavoritesIndex() {
            super("user-dashboard-favorites", EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static class MigrateStoredQueryIndex
    extends MigrateVersion166LastChangeTrackingValueIndex {
        public MigrateStoredQueryIndex() {
            super("issue-queries", EStorageMigratorType.PROJECT);
        }

        public Set<String> getAdditionalStoreNames() {
            return Set.of("test-queries", "spec-item-queries");
        }
    }
}

