/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion43IssueTrackerStartTimestampMigration {
    private static final Set<String> CONNECTORS_WITH_START_TIMESTAMP_OPTION = ProjectVersion43IssueTrackerStartTimestampMigration.getConnectorsWithStartTimestampOption();
    private static final String NEW_START_TIMESTAMP_NAME = "Import Issue history since";
    private static final String OLD_START_TIMESTAMP_NAME = "Start Timestamp";

    private static Set<String> getConnectorsWithStartTimestampOption() {
        Set<String> connectors = EnumSet.allOf(EIssueTracker.class).stream().map(EIssueTracker::getReadableName).collect(Collectors.toSet());
        for (ERequirementsManagementTool enumValue : ERequirementsManagementTool.values()) {
            connectors.add(enumValue.getReadableName());
        }
        return connectors;
    }

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion43IssueTrackerStartTimestampMigration::migrateStartTimestamp);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateStartTimestamp(ConnectorConfiguration connectorConfiguration) {
        String changedSince;
        if (CONNECTORS_WITH_START_TIMESTAMP_OPTION.contains(connectorConfiguration.getType()) && (changedSince = connectorConfiguration.getOptionValue(OLD_START_TIMESTAMP_NAME)) != null) {
            connectorConfiguration.removeOptions(Collections.singleton(OLD_START_TIMESTAMP_NAME));
            connectorConfiguration.setOptionValue(NEW_START_TIMESTAMP_NAME, changedSince);
        }
        return connectorConfiguration;
    }
}

